/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.boofcv.converters.extended;

import com.thoughtworks.boofcv.converters.extended.JavaClassConverter;
import com.thoughtworks.boofcv.core.util.XStreamClassLoader;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class JavaMethodConverter
implements Converter {
    private final SingleValueConverter javaClassConverter;

    public JavaMethodConverter(XStreamClassLoader classLoader) {
        this.javaClassConverter = new JavaClassConverter(classLoader);
    }

    public boolean canConvert(Class type) {
        return type.equals(Method.class) || type.equals(Constructor.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (source instanceof Method) {
            Method method = (Method)source;
            String declaringClassName = this.javaClassConverter.toString(method.getDeclaringClass());
            this.marshalMethod(writer, declaringClassName, method.getName(), method.getParameterTypes());
        } else {
            Constructor method = (Constructor)source;
            String declaringClassName = this.javaClassConverter.toString(method.getDeclaringClass());
            this.marshalMethod(writer, declaringClassName, null, method.getParameterTypes());
        }
    }

    private void marshalMethod(HierarchicalStreamWriter writer, String declaringClassName, String methodName, Class[] parameterTypes) {
        writer.startNode("class");
        writer.setValue(declaringClassName);
        writer.endNode();
        if (methodName != null) {
            writer.startNode("name");
            writer.setValue(methodName);
            writer.endNode();
        }
        writer.startNode("parameter-types");
        for (int i = 0; i < parameterTypes.length; ++i) {
            writer.startNode("class");
            writer.setValue(this.javaClassConverter.toString((Object)parameterTypes[i]));
            writer.endNode();
        }
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            boolean isMethodNotConstructor = context.getRequiredType().equals(Method.class);
            reader.moveDown();
            String declaringClassName = reader.getValue();
            Class declaringClass = (Class)this.javaClassConverter.fromString(declaringClassName);
            reader.moveUp();
            String methodName = null;
            if (isMethodNotConstructor) {
                reader.moveDown();
                methodName = reader.getValue();
                reader.moveUp();
            }
            reader.moveDown();
            ArrayList<Object> parameterTypeList = new ArrayList<Object>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String parameterTypeName = reader.getValue();
                parameterTypeList.add(this.javaClassConverter.fromString(parameterTypeName));
                reader.moveUp();
            }
            Class[] parameterTypes = parameterTypeList.toArray(new Class[parameterTypeList.size()]);
            reader.moveUp();
            if (isMethodNotConstructor) {
                return declaringClass.getDeclaredMethod(methodName, parameterTypes);
            }
            return declaringClass.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new ConversionException((Throwable)e);
        }
    }
}

