/*
 * Decompiled with CFR 0.152.
 */
package boofcv.testing;

import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GImageSingleBand;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;
import sun.awt.image.ShortInterleavedRaster;

public class BoofTesting {
    public static <T> T convertToGenericType(Class<?> type) {
        if (type == ImageSInt8.class || type == ImageUInt8.class) {
            return (T)ImageInt8.class;
        }
        if (type == ImageSInt16.class || type == ImageUInt16.class) {
            return (T)ImageInt16.class;
        }
        return (T)type;
    }

    public static ImageDataType convertToGenericType(ImageDataType type) {
        if (type.isInteger()) {
            if (type.getNumBits() == 8) {
                return ImageDataType.I8;
            }
            if (type.getNumBits() == 16) {
                return ImageDataType.I16;
            }
        }
        return type;
    }

    public static <T> T convertGenericToSpecificType(Class<?> type) {
        if (type == ImageInt8.class) {
            return (T)ImageUInt8.class;
        }
        if (type == ImageInt16.class) {
            return (T)ImageSInt16.class;
        }
        if (type == InterleavedI8.class) {
            return (T)InterleavedU8.class;
        }
        if (type == InterleavedI16.class) {
            return (T)InterleavedS16.class;
        }
        return (T)type;
    }

    public static <T extends ImageBase> T createSubImageOf(T input) {
        if (input instanceof ImageSingleBand) {
            return (T)BoofTesting.createSubImageOf_S((ImageSingleBand)input);
        }
        if (input instanceof MultiSpectral) {
            return (T)BoofTesting.createSubImageOf_MS((MultiSpectral)input);
        }
        if (input instanceof ImageInterleaved) {
            return (T)BoofTesting.createSubImageOf_I((ImageInterleaved)input);
        }
        throw new IllegalArgumentException("Add support for this image type");
    }

    public static <T extends ImageSingleBand> T createSubImageOf_S(T input) {
        ImageSingleBand ret = (ImageSingleBand)input._createNew(input.width + 10, input.height + 12);
        ret = ret.subimage(5, 7, input.width + 5, input.height + 7, null);
        ret.setTo(input);
        return (T)ret;
    }

    public static <T extends ImageInterleaved> T createSubImageOf_I(T input) {
        ImageInterleaved ret = (ImageInterleaved)input._createNew(input.width + 10, input.height + 12);
        ret = ret.subimage(5, 7, input.width + 5, input.height + 7, null);
        ret.setTo(input);
        return (T)ret;
    }

    public static <T extends MultiSpectral> T createSubImageOf_MS(T input) {
        MultiSpectral ret = new MultiSpectral(input.type, input.width, input.height, input.getNumBands());
        for (int i = 0; i < input.getNumBands(); ++i) {
            ret.bands[i] = BoofTesting.createSubImageOf_S(input.getBand(i));
        }
        ret.stride = ((ImageSingleBand)ret.bands[0]).stride;
        ret.startIndex = ((ImageSingleBand)ret.bands[0]).startIndex;
        return (T)ret;
    }

    public static void checkImageDimensionValidation(Object testClass, int numFunctions) {
        Method[] methods;
        int count = 0;
        for (Method m : methods = testClass.getClass().getMethods()) {
            if (!BoofTesting.areAllInputsImages(m)) continue;
            Class<?>[] params = m.getParameterTypes();
            Object[] inputs = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                inputs[i] = GeneralizedImageOps.createSingleBand(params[i], 10, 20);
            }
            try {
                m.invoke(testClass, inputs);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (int target = 0; target < params.length; ++target) {
                for (int i = 0; i < params.length; ++i) {
                    inputs[i] = i != target ? GeneralizedImageOps.createSingleBand(params[i], 10, 20) : GeneralizedImageOps.createSingleBand(params[i], 11, 22);
                }
                try {
                    m.invoke(testClass, inputs);
                    throw new RuntimeException("Expected an exception here");
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException().getClass() == IllegalArgumentException.class) continue;
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++count;
        }
        if (count != numFunctions) {
            throw new RuntimeException("Unexpected number of functions");
        }
    }

    private static boolean areAllInputsImages(Method m) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length == 0) {
            return false;
        }
        for (Class<?> p : params) {
            if (ImageSingleBand.class.isAssignableFrom(p)) continue;
            return false;
        }
        return true;
    }

    public static void checkSubImage(Object testClass, String function, boolean checkEquals, Object ... inputParam) {
        try {
            int i;
            ImageBase[] larger = new ImageBase[inputParam.length];
            ImageBase[] subImg = new ImageBase[inputParam.length];
            Class[] paramDesc = new Class[inputParam.length];
            Object[] inputModified = new Object[inputParam.length];
            for (int i2 = 0; i2 < inputParam.length; ++i2) {
                if (ImageBase.class.isAssignableFrom(inputParam[i2].getClass())) {
                    ImageBase img = (ImageBase)inputParam[i2];
                    larger[i2] = img._createNew(img.getWidth() + 10, img.getHeight() + 12);
                    subImg[i2] = larger[i2].subimage(5, 6, 5 + img.getWidth(), 6 + img.getHeight(), null);
                    subImg[i2].setTo(img);
                }
                inputModified[i2] = inputParam[i2];
                paramDesc[i2] = inputParam[i2].getClass();
            }
            Method m = BoofTesting.findMethod(testClass.getClass(), function, paramDesc);
            m.invoke(testClass, inputModified);
            for (i = 0; i < inputModified.length; ++i) {
                if (subImg[i] == null) continue;
                inputModified[i] = subImg[i];
            }
            m.invoke(testClass, inputModified);
            if (checkEquals) {
                for (i = 0; i < inputParam.length; ++i) {
                    if (subImg[i] == null) continue;
                    BoofTesting.assertEquals((ImageBase)inputModified[i], subImg[i], 0.0);
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findMethod(Class<?> type, String name, Class<?> ... params) {
        Method[] methods = type.getMethods();
        ArrayList<Method> found = new ArrayList<Method>();
        for (Method m : methods) {
            int i;
            Class<?>[] a;
            if (m.getName().compareTo(name) != 0 || (a = m.getParameterTypes()).length != params.length) continue;
            boolean match = true;
            for (i = 0; i < a.length; ++i) {
                if (a[i] == params[i]) continue;
                match = false;
                break;
            }
            if (match) {
                return m;
            }
            match = true;
            for (i = 0; i < a.length; ++i) {
                if (params[i] == a[i] || a[i].isPrimitive() && (a[i] == Byte.TYPE && params[i] == Byte.class || a[i] == Short.TYPE && params[i] == Short.class || a[i] == Integer.TYPE && params[i] == Integer.class || a[i] == Long.TYPE && params[i] == Long.class || a[i] == Float.TYPE && params[i] == Float.class || a[i] == Double.TYPE && params[i] == Double.class) || a[i].isAssignableFrom(params[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            found.add(m);
        }
        if (found.size() == 1) {
            return (Method)found.get(0);
        }
        throw new RuntimeException("Couldn't find matching *public* function to " + name);
    }

    public static void callStaticMethod(Class<?> classType, String name, Object ... inputs) {
        Class[] params = new Class[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            params[i] = inputs[i].getClass();
        }
        Method m = BoofTesting.findMethod(classType, name, params);
        if (m == null) {
            for (int i = 0; i < inputs.length; ++i) {
                if (params[i] == Integer.class) {
                    params[i] = Integer.TYPE;
                    continue;
                }
                if (params[i] == Float.class) {
                    params[i] = Float.TYPE;
                    continue;
                }
                if (params[i] != Double.class) continue;
                params[i] = Double.TYPE;
            }
            m = BoofTesting.findMethod(classType, name, params);
        }
        if (m == null) {
            throw new IllegalArgumentException("Method not found");
        }
        try {
            m.invoke(null, inputs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static int findMethodThenCall(Object owner, String ownerMethod, Class target, String targetMethod) {
        int total = 0;
        Method[] list = target.getMethods();
        try {
            Method om = owner.getClass().getMethod(ownerMethod, Method.class);
            for (Method m : list) {
                if (!m.getName().equals(targetMethod)) continue;
                om.invoke(owner, m);
                ++total;
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return total;
    }

    public static void assertEquals(double[] a, double[] b, double tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - b[i]);
            if (!(diff > tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(double[] a, float[] b, double tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - (double)b[i]);
            if (!(diff > tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(double[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs((int)a[i] - b[i]);
            if (diff == 0.0) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(float[] a, float[] b, float tol) {
        for (int i = 0; i < a.length; ++i) {
            double diff = Math.abs(a[i] - b[i]);
            if (!(diff > (double)tol)) continue;
            throw new RuntimeException("Element " + i + " not equals. " + a[i] + " " + b[i]);
        }
    }

    public static void assertEquals(ImageBase imgA, ImageBase imgB, double tol) {
        if (imgA instanceof ImageSingleBand) {
            GImageSingleBand a = FactoryGImageSingleBand.wrap((ImageSingleBand)imgA);
            GImageSingleBand b = FactoryGImageSingleBand.wrap((ImageSingleBand)imgB);
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    double valB;
                    double valA = a.get(x, y).doubleValue();
                    double difference = valA - (valB = b.get(x, y).doubleValue());
                    if (!(Math.abs(difference) > tol)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof MultiSpectral) {
            MultiSpectral a = (MultiSpectral)imgA;
            MultiSpectral b = (MultiSpectral)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEquals(a.getBand(band), b.getBand(band), tol);
            }
        } else if (imgA instanceof ImageInterleaved) {
            ImageInterleaved a = (ImageInterleaved)imgA;
            ImageInterleaved b = (ImageInterleaved)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            int numBands = a.getNumBands();
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    for (int band = 0; band < numBands; ++band) {
                        double valB;
                        double valA = GeneralizedImageOps.get(a, x, y, band);
                        double difference = valA - (valB = GeneralizedImageOps.get(b, x, y, band));
                        if (!(Math.abs(difference) > tol)) continue;
                        throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                    }
                }
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsInner(ImageBase imgA, ImageBase imgB, double tol, int borderX, int borderY, boolean relative) {
        if (imgA instanceof ImageSingleBand) {
            GImageSingleBand a = FactoryGImageSingleBand.wrap((ImageSingleBand)imgA);
            GImageSingleBand b = FactoryGImageSingleBand.wrap((ImageSingleBand)imgB);
            for (int y = borderY; y < imgA.height - borderY; ++y) {
                for (int x = borderX; x < imgA.width - borderX; ++x) {
                    double valA = a.get(x, y).doubleValue();
                    double valB = b.get(x, y).doubleValue();
                    double error = Math.abs(valA - valB);
                    if (relative) {
                        double denominator = Math.abs(valA) + Math.abs(valB);
                        if (denominator == 0.0) {
                            denominator = 1.0;
                        }
                        error /= denominator;
                    }
                    if (!(error > tol)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof MultiSpectral) {
            MultiSpectral a = (MultiSpectral)imgA;
            MultiSpectral b = (MultiSpectral)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEqualsInner(a.getBand(band), b.getBand(band), tol, borderX, borderY, relative);
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsRelative(ImageBase imgA, ImageBase imgB, double tolFrac) {
        if (imgA instanceof ImageSingleBand) {
            GImageSingleBand a = FactoryGImageSingleBand.wrap((ImageSingleBand)imgA);
            GImageSingleBand b = FactoryGImageSingleBand.wrap((ImageSingleBand)imgB);
            for (int y = 0; y < imgA.height; ++y) {
                for (int x = 0; x < imgA.width; ++x) {
                    double valA = a.get(x, y).doubleValue();
                    double valB = b.get(x, y).doubleValue();
                    double difference = valA - valB;
                    double max = Math.max(Math.abs(valA), Math.abs(valB));
                    if (max == 0.0) {
                        max = 1.0;
                    }
                    if (!(Math.abs(difference) / max > tolFrac)) continue;
                    throw new RuntimeException("Values not equal at (" + x + "," + y + ") " + valA + "  " + valB);
                }
            }
        } else if (imgA instanceof MultiSpectral) {
            MultiSpectral a = (MultiSpectral)imgA;
            MultiSpectral b = (MultiSpectral)imgB;
            if (a.getNumBands() != b.getNumBands()) {
                throw new RuntimeException("Number of bands not equal");
            }
            for (int band = 0; band < a.getNumBands(); ++band) {
                BoofTesting.assertEqualsRelative(a.getBand(band), b.getBand(band), tolFrac);
            }
        } else {
            throw new RuntimeException("Unknown image type");
        }
    }

    public static void assertEqualsBorder(ImageSingleBand imgA, ImageSingleBand imgB, double tol, int borderX, int borderY) {
        if (imgA.getWidth() != imgB.getWidth()) {
            throw new RuntimeException("Widths are not equals");
        }
        if (imgA.getHeight() != imgB.getHeight()) {
            throw new RuntimeException("Heights are not equals");
        }
        GImageSingleBand a = FactoryGImageSingleBand.wrap(imgA);
        GImageSingleBand b = FactoryGImageSingleBand.wrap(imgB);
        for (int y = 0; y < imgA.getHeight(); ++y) {
            int x;
            for (x = 0; x < borderX; ++x) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
            for (x = imgA.getWidth() - borderX; x < imgA.getWidth(); ++x) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
        }
        for (int x = borderX; x < imgA.getWidth() - borderX; ++x) {
            int y;
            for (y = 0; y < borderY; ++y) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
            for (y = imgA.getHeight() - borderY; y < imgA.getHeight(); ++y) {
                BoofTesting.compareValues(tol, a, b, x, y);
            }
        }
    }

    private static void compareValues(double tol, GImageSingleBand a, GImageSingleBand b, int x, int y) {
        double normalizer = Math.abs(a.get(x, y).doubleValue()) + Math.abs(b.get(x, y).doubleValue());
        if (normalizer < 1.0) {
            normalizer = 1.0;
        }
        if (Math.abs(a.get(x, y).doubleValue() - b.get(x, y).doubleValue()) / normalizer > tol) {
            throw new RuntimeException("values not equal at (" + x + " " + y + ") " + a.get(x, y) + "  " + b.get(x, y));
        }
    }

    public static void checkEquals(BufferedImage imgA, ImageBase imgB, boolean boofcvBandOrder, double tol) {
        if (ImageUInt8.class == imgB.getClass()) {
            BoofTesting.checkEquals(imgA, (ImageUInt8)imgB);
        } else if (ImageInt16.class.isAssignableFrom(imgB.getClass())) {
            BoofTesting.checkEquals(imgA, (ImageInt16)imgB);
        } else if (ImageFloat32.class == imgB.getClass()) {
            BoofTesting.checkEquals(imgA, (ImageFloat32)imgB, (float)tol);
        } else if (InterleavedU8.class == imgB.getClass()) {
            BoofTesting.checkEquals(imgA, (InterleavedU8)imgB);
        } else if (MultiSpectral.class == imgB.getClass()) {
            BoofTesting.checkEquals(imgA, (MultiSpectral)imgB, boofcvBandOrder, (float)tol);
        } else {
            throw new IllegalArgumentException("Unknown");
        }
    }

    public static void checkEquals(BufferedImage imgA, ImageUInt8 imgB) {
        ByteInterleavedRaster raster;
        if (imgA.getRaster() instanceof ByteInterleavedRaster && imgA.getType() != 13 && (raster = (ByteInterleavedRaster)imgA.getRaster()).getNumBands() == 1) {
            int strideA = raster.getScanlineStride();
            int offsetA = raster.getDataOffset(0) - raster.getNumBands() + 1;
            for (int i = 0; i < imgA.getHeight(); ++i) {
                for (int j = 0; j < imgA.getWidth(); ++j) {
                    int valB = imgB.get(j, i);
                    int valA = raster.getDataStorage()[offsetA + i * strideA + j];
                    if (!imgB.getTypeInfo().isSigned()) {
                        valA &= 0xFF;
                    }
                    if (valA == valB) continue;
                    throw new RuntimeException("Images are not equal: " + valA + " " + valB);
                }
            }
            return;
        }
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                int rgb = imgA.getRGB(x, y);
                int gray = ((rgb >>> 16 & 0xFF) + (rgb >>> 8 & 0xFF) + (rgb & 0xFF)) / 3;
                int grayB = imgB.get(x, y);
                if (!imgB.getTypeInfo().isSigned()) {
                    gray &= 0xFF;
                }
                if (Math.abs(gray - grayB) == 0) continue;
                throw new RuntimeException("images are not equal: (" + x + " , " + y + ") A = " + gray + " B = " + grayB);
            }
        }
    }

    public static void checkEquals(BufferedImage imgA, ImageInt16 imgB) {
        block11: {
            block12: {
                block10: {
                    if (!(imgA.getRaster() instanceof ByteInterleavedRaster) || imgA.getType() == 13) break block10;
                    ByteInterleavedRaster raster = (ByteInterleavedRaster)imgA.getRaster();
                    if (raster.getNumBands() == 1) {
                        int strideA = raster.getScanlineStride();
                        int offsetA = raster.getDataOffset(0) - raster.getNumBands() + 1;
                        for (int i = 0; i < imgA.getHeight(); ++i) {
                            for (int j = 0; j < imgA.getWidth(); ++j) {
                                int valB = imgB.get(j, i);
                                int valA = raster.getDataStorage()[offsetA + i * strideA + j];
                                if (!imgB.getTypeInfo().isSigned()) {
                                    valA &= 0xFFFF;
                                }
                                if (valA == valB) continue;
                                throw new RuntimeException("Images are not equal: " + valA + " " + valB);
                            }
                        }
                        return;
                    }
                    break block11;
                }
                if (!(imgA.getRaster() instanceof ShortInterleavedRaster)) break block12;
                ShortInterleavedRaster raster = (ShortInterleavedRaster)imgA.getRaster();
                if (raster.getNumBands() != 1) break block11;
                int strideA = raster.getScanlineStride();
                int offsetA = raster.getDataOffset(0) - raster.getNumBands() + 1;
                for (int i = 0; i < imgA.getHeight(); ++i) {
                    for (int j = 0; j < imgA.getWidth(); ++j) {
                        int valB = imgB.get(j, i);
                        int valA = raster.getDataStorage()[offsetA + i * strideA + j];
                        if (!imgB.getTypeInfo().isSigned()) {
                            valA &= 0xFFFF;
                        }
                        if (valA == valB) continue;
                        throw new RuntimeException("Images are not equal: " + valA + " " + valB);
                    }
                }
                break block11;
            }
            for (int y = 0; y < imgA.getHeight(); ++y) {
                for (int x = 0; x < imgA.getWidth(); ++x) {
                    int rgb = imgA.getRGB(x, y);
                    int gray = ((rgb >>> 16 & 0xFF) + (rgb >>> 8 & 0xFF) + (rgb & 0xFF)) / 3;
                    int grayB = imgB.get(x, y);
                    if (!imgB.getTypeInfo().isSigned()) {
                        gray &= 0xFFFF;
                    }
                    if (Math.abs(gray - grayB) == 0) continue;
                    throw new RuntimeException("images are not equal: (" + x + " , " + y + ") A = " + gray + " B = " + grayB);
                }
            }
        }
    }

    public static void checkEquals(BufferedImage imgA, ImageFloat32 imgB, float tol) {
        ByteInterleavedRaster raster;
        if (imgA.getRaster() instanceof ByteInterleavedRaster && imgA.getType() != 13 && (raster = (ByteInterleavedRaster)imgA.getRaster()).getNumBands() == 1) {
            int strideA = raster.getScanlineStride();
            int offsetA = raster.getDataOffset(0) - raster.getNumBands() + 1;
            for (int i = 0; i < imgA.getHeight(); ++i) {
                for (int j = 0; j < imgA.getWidth(); ++j) {
                    float valB = imgB.get(j, i);
                    int valA = raster.getDataStorage()[offsetA + i * strideA + j];
                    if (!(Math.abs((float)(valA &= 0xFF) - valB) > tol)) continue;
                    throw new RuntimeException("Images are not equal: A = " + valA + " B = " + valB);
                }
            }
            return;
        }
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                float grayB;
                int rgb = imgA.getRGB(x, y);
                float gray = (float)((rgb >>> 16 & 0xFF) + (rgb >>> 8 & 0xFF) + (rgb & 0xFF)) / 3.0f;
                if (!(Math.abs(gray - (grayB = imgB.get(x, y))) > tol)) continue;
                throw new RuntimeException("images are not equal: A = " + gray + " B = " + grayB);
            }
        }
    }

    public static void checkEquals(BufferedImage imgA, InterleavedU8 imgB) {
        ByteInterleavedRaster raster;
        if (imgA.getRaster() instanceof ByteInterleavedRaster && (raster = (ByteInterleavedRaster)imgA.getRaster()).getNumBands() == 1) {
            for (int i = 0; i < imgA.getHeight(); ++i) {
                for (int j = 0; j < imgA.getWidth(); ++j) {
                    int valB = imgB.getBand(j, i, 0);
                    int valA = raster.getDataStorage()[i * imgA.getWidth() + j] & 0xFF;
                    if (valA == valB) continue;
                    throw new RuntimeException("Images are not equal");
                }
            }
            return;
        }
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                int rgb = imgA.getRGB(x, y);
                int r = rgb >>> 16 & 0xFF;
                int g = rgb >>> 8 & 0xFF;
                int b = rgb & 0xFF;
                if (Math.abs(b - imgB.getBand(x, y, 0) & 0xFF) != 0) {
                    throw new RuntimeException("images are not equal: ");
                }
                if (Math.abs(g - imgB.getBand(x, y, 1) & 0xFF) != 0) {
                    throw new RuntimeException("images are not equal: ");
                }
                if (Math.abs(r - imgB.getBand(x, y, 2) & 0xFF) == 0) continue;
                throw new RuntimeException("images are not equal: ");
            }
        }
    }

    public static void checkEquals(WritableRaster imgA, MultiSpectral imgB, float tol) {
        if (imgA.getNumBands() != imgB.getNumBands()) {
            throw new RuntimeException("Number of bands not equals");
        }
        if (imgA instanceof ByteInterleavedRaster) {
            ByteInterleavedRaster raster = (ByteInterleavedRaster)imgA;
            byte[] dataA = raster.getDataStorage();
            int strideA = raster.getScanlineStride();
            int offsetA = raster.getDataOffset(0) - raster.getPixelStride() + 1;
            for (int y = 0; y < imgA.getHeight(); ++y) {
                int indexA = offsetA + strideA * y;
                for (int x = 0; x < imgA.getWidth(); ++x) {
                    for (int k = 0; k < imgB.getNumBands(); ++k) {
                        int n = indexA++;
                        int valueA = dataA[n] & 0xFF;
                        double valueB = GeneralizedImageOps.get(imgB.getBand(k), x, y);
                        if (!(Math.abs((double)valueA - valueB) > (double)tol)) continue;
                        throw new RuntimeException("Images are not equal: A = " + valueA + " B = " + valueB);
                    }
                }
            }
        } else if (imgA instanceof IntegerInterleavedRaster) {
            IntegerInterleavedRaster raster = (IntegerInterleavedRaster)imgA;
            int[] dataA = raster.getDataStorage();
            int strideA = raster.getScanlineStride();
            int offsetA = raster.getDataOffset(0) - raster.getPixelStride() + 1;
            for (int y = 0; y < imgA.getHeight(); ++y) {
                int indexA = offsetA + strideA * y;
                for (int x = 0; x < imgA.getWidth(); ++x) {
                    int found2;
                    int found1;
                    int found0;
                    int valueA = dataA[indexA++];
                    if (imgB.getNumBands() == 4) {
                        found0 = valueA >> 24 & 0xFF;
                        found1 = valueA >> 16 & 0xFF;
                        found2 = valueA >> 8 & 0xFF;
                        int found3 = valueA & 0xFF;
                        double expected0 = GeneralizedImageOps.get(imgB.getBand(0), x, y);
                        double expected1 = GeneralizedImageOps.get(imgB.getBand(1), x, y);
                        double expected2 = GeneralizedImageOps.get(imgB.getBand(2), x, y);
                        double expected3 = GeneralizedImageOps.get(imgB.getBand(3), x, y);
                        if (Math.abs((double)found0 - expected0) > (double)tol) {
                            throw new RuntimeException("Images are not equal");
                        }
                        if (Math.abs((double)found1 - expected1) > (double)tol) {
                            throw new RuntimeException("Images are not equal");
                        }
                        if (Math.abs((double)found2 - expected2) > (double)tol) {
                            throw new RuntimeException("Images are not equal");
                        }
                        if (!(Math.abs((double)found3 - expected3) > (double)tol)) continue;
                        throw new RuntimeException("Images are not equal");
                    }
                    if (imgB.getNumBands() == 3) {
                        found0 = valueA >> 16 & 0xFF;
                        found1 = valueA >> 8 & 0xFF;
                        found2 = valueA & 0xFF;
                        double expected0 = GeneralizedImageOps.get(imgB.getBand(0), x, y);
                        double expected1 = GeneralizedImageOps.get(imgB.getBand(1), x, y);
                        double expected2 = GeneralizedImageOps.get(imgB.getBand(2), x, y);
                        if (Math.abs((double)found0 - expected0) > (double)tol) {
                            throw new RuntimeException("Images are not equal");
                        }
                        if (Math.abs((double)found1 - expected1) > (double)tol) {
                            throw new RuntimeException("Images are not equal");
                        }
                        if (!(Math.abs((double)found2 - expected2) > (double)tol)) continue;
                        throw new RuntimeException("Images are not equal");
                    }
                    throw new RuntimeException("Unexpectd number of bands");
                }
            }
        } else {
            throw new RuntimeException("Add support for raster type " + imgA.getClass().getSimpleName());
        }
    }

    public static void checkEquals(BufferedImage imgA, MultiSpectral imgB, boolean boofcvBandOrder, float tol) {
        ByteInterleavedRaster raster;
        if (imgA.getRaster() instanceof ByteInterleavedRaster && imgA.getType() != 13 && (raster = (ByteInterleavedRaster)imgA.getRaster()).getNumBands() == 1) {
            GImageSingleBand band = FactoryGImageSingleBand.wrap(imgB.getBand(0));
            int strideA = raster.getScanlineStride();
            int offsetA = raster.getDataOffset(0) - raster.getPixelStride() + 1;
            for (int i = 0; i < imgA.getHeight(); ++i) {
                for (int j = 0; j < imgA.getWidth(); ++j) {
                    double valB = band.get(j, i).doubleValue();
                    int valA = raster.getDataStorage()[offsetA + i * strideA + j];
                    if (!(Math.abs((double)(valA &= 0xFF) - valB) > (double)tol)) continue;
                    throw new RuntimeException("Images are not equal: A = " + valA + " B = " + valB);
                }
            }
            return;
        }
        int[] bandOrder = boofcvBandOrder ? (imgB.getNumBands() == 4 ? new int[]{1, 2, 3, 0} : new int[]{0, 1, 2}) : (imgA.getType() == 1 ? new int[]{0, 1, 2} : (imgA.getType() == 4 || imgA.getType() == 5 ? new int[]{2, 1, 0} : (imgA.getType() == 6 ? new int[]{0, 3, 2, 1} : (imgA.getType() == 2 ? new int[]{0, 1, 2, 3} : new int[]{0, 1, 2}))));
        int[] expected = new int[4];
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                double found;
                int i;
                int rgb = imgA.getRGB(x, y);
                expected[0] = rgb >>> 24 & 0xFF;
                expected[1] = rgb >>> 16 & 0xFF;
                expected[2] = rgb >>> 8 & 0xFF;
                expected[3] = rgb & 0xFF;
                if (imgB.getNumBands() == 4) {
                    for (i = 0; i < 4; ++i) {
                        found = GeneralizedImageOps.get(imgB.getBand(bandOrder[i]), x, y);
                        if (!(Math.abs(Math.exp((double)expected[i] - found)) > (double)tol)) continue;
                        for (int j = 0; j < 4; ++j) {
                            System.out.println(expected[j] + " " + GeneralizedImageOps.get(imgB.getBand(bandOrder[j]), x, y));
                        }
                        throw new RuntimeException("Images are not equal: band - " + i + " type " + imgA.getType());
                    }
                    continue;
                }
                if (imgB.getNumBands() == 3) {
                    for (i = 0; i < 3; ++i) {
                        found = GeneralizedImageOps.get(imgB.getBand(bandOrder[i]), x, y);
                        if (!(Math.abs((double)expected[i + 1] - found) > (double)tol)) continue;
                        for (int j = 0; j < 3; ++j) {
                            System.out.println(expected[j + 1] + " " + GeneralizedImageOps.get(imgB.getBand(bandOrder[j]), x, y));
                        }
                        throw new RuntimeException("Images are not equal: band - " + i + " type " + imgA.getType());
                    }
                    continue;
                }
                throw new RuntimeException("Unexpectd number of bands");
            }
        }
    }

    public static void checkBorderZero(ImageSingleBand outputImage, int border) {
        GImageSingleBand img = FactoryGImageSingleBand.wrap(outputImage);
        for (int y = 0; y < img.getHeight(); ++y) {
            if (y >= border && y < img.getHeight() - border) continue;
            for (int x = 0; x < img.getWidth(); ++x) {
                if (x >= border && x < img.getWidth() - border || img.get(x, y).intValue() == 0) continue;
                throw new RuntimeException("The border is not zero: " + x + " " + y);
            }
        }
    }

    public static void printDiff(ImageSingleBand imgA, ImageSingleBand imgB) {
        GImageSingleBand a = FactoryGImageSingleBand.wrap(imgA);
        GImageSingleBand b = FactoryGImageSingleBand.wrap(imgB);
        System.out.println("------- Difference -----------");
        for (int y = 0; y < imgA.getHeight(); ++y) {
            for (int x = 0; x < imgA.getWidth(); ++x) {
                double diff = Math.abs(a.get(x, y).doubleValue() - b.get(x, y).doubleValue());
                System.out.printf("%2d ", (int)diff);
            }
            System.out.println();
        }
    }
}

