/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel1D;

public class Kernel1D_F64
extends Kernel1D {
    public double[] data;

    public Kernel1D_F64(double[] data, int width) {
        if (width % 2 == 0 && width <= 0) {
            throw new IllegalArgumentException("invalid width");
        }
        this.width = width;
        this.data = new double[width];
        System.arraycopy(data, 0, this.data, 0, width);
    }

    public Kernel1D_F64(int width) {
        if (width % 2 == 0 && width <= 0) {
            throw new IllegalArgumentException("invalid width");
        }
        this.data = new double[width];
        this.width = width;
    }

    public Kernel1D_F64(int width, double ... value) {
        if (width % 2 == 0 && width <= 0) {
            throw new IllegalArgumentException("invalid width");
        }
        this.data = new double[width];
        this.width = width;
        System.arraycopy(value, 0, this.data, 0, width);
    }

    protected Kernel1D_F64() {
    }

    public static Kernel1D_F64 wrap(double[] data, int width) {
        if (width % 2 == 0 && width <= 0 && width > data.length) {
            throw new IllegalArgumentException("invalid width");
        }
        Kernel1D_F64 ret = new Kernel1D_F64();
        ret.data = data;
        ret.width = width;
        return ret;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    public double get(int i) {
        return this.data[i];
    }

    public double[] getData() {
        return this.data;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
            System.out.printf("%6.3f ", this.data[i]);
        }
        System.out.println();
    }
}

