/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.convolve;

import boofcv.abst.filter.convolve.GenericConvolveDown;
import boofcv.alg.filter.convolve.ConvolveDownNoBorder;
import boofcv.alg.filter.convolve.ConvolveDownNormalized;
import boofcv.core.image.border.BorderType;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.image.ImageSingleBand;
import boofcv.testing.BoofTesting;
import java.lang.reflect.Method;

public class FactoryConvolveDown {
    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> GenericConvolveDown<Input, Output> convolve(Kernel1D kernel, Class<Input> inputType, Class<Output> outputType, BorderType border, boolean isHorizontal, int skip) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        String direction = isHorizontal ? "horizontal" : "vertical";
        try {
            switch (border) {
                case SKIP: {
                    m = ConvolveDownNoBorder.class.getMethod(direction, kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                case EXTENDED: {
                    throw new IllegalArgumentException("Extended border is currently not supported.");
                }
                case NORMALIZED: {
                    m = ConvolveDownNormalized.class.getMethod(direction, kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + (Object)((Object)border));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolveDown(m, kernel, border, skip, inputType);
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> GenericConvolveDown<Input, Output> convolve(Kernel2D kernel, Class<Input> inputType, Class<Output> outputType, BorderType border, int skip) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        try {
            switch (border) {
                case SKIP: {
                    m = ConvolveDownNoBorder.class.getMethod("convolve", kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                case EXTENDED: {
                    throw new IllegalArgumentException("Extended border is currently not supported.");
                }
                case NORMALIZED: {
                    m = ConvolveDownNormalized.class.getMethod("convolve", kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + (Object)((Object)border));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolveDown(m, kernel, border, skip, inputType);
    }
}

