/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixel;
import boofcv.struct.image.ImageUInt8;

public class ImplBilinearPixel_U8
extends BilinearPixel<ImageUInt8> {
    public ImplBilinearPixel_U8() {
    }

    public ImplBilinearPixel_U8(ImageUInt8 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((ImageUInt8)this.orig).startIndex + yt * this.stride + xt;
        byte[] data = ((ImageUInt8)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * (float)(data[index] & 0xFF);
        val += ax * (1.0f - ay) * (float)(data[index + 1] & 0xFF);
        val += ax * ay * (float)(data[index + 1 + this.stride] & 0xFF);
        return val += (1.0f - ax) * ay * (float)(data[index + this.stride] & 0xFF);
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            throw new IllegalArgumentException("Point is outside of the image");
        }
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((ImageUInt8)this.orig).startIndex + yt * this.stride + xt;
        int dx = xt == this.width - 1 ? 0 : 1;
        int dy = yt == this.height - 1 ? 0 : this.stride;
        byte[] data = ((ImageUInt8)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * (float)(data[index] & 0xFF);
        val += ax * (1.0f - ay) * (float)(data[index + dx] & 0xFF);
        val += ax * ay * (float)(data[index + dx + dy] & 0xFF);
        return val += (1.0f - ax) * ay * (float)(data[index + dy] & 0xFF);
    }
}

