/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class GradientPrewitt_Shared {
    public static void process(ImageUInt8 orig, ImageSInt16 derivX, ImageSInt16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int strideSrc = orig.getStride();
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int endX = indexSrc + width - 2;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            for (indexSrc = orig.startIndex + orig.stride * y + 1; indexSrc < endX; ++indexSrc) {
                int w = (data[indexSrc + strideSrc + 1] & 0xFF) - (data[indexSrc - strideSrc - 1] & 0xFF);
                int v = (data[indexSrc + strideSrc - 1] & 0xFF) - (data[indexSrc - strideSrc + 1] & 0xFF);
                imgY[indexY++] = (short)((data[indexSrc + strideSrc] & 0xFF) + w + v - (data[indexSrc - strideSrc] & 0xFF));
                imgX[indexX++] = (short)((data[indexSrc + 1] & 0xFF) + w - v - (data[indexSrc - 1] & 0xFF));
            }
        }
    }

    public static void process(ImageSInt16 orig, ImageSInt16 derivX, ImageSInt16 derivY) {
        short[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int strideSrc = orig.getStride();
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int endX = indexSrc + width - 2;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            for (indexSrc = orig.startIndex + orig.stride * y + 1; indexSrc < endX; ++indexSrc) {
                int w = data[indexSrc + strideSrc + 1] - data[indexSrc - strideSrc - 1];
                int v = data[indexSrc + strideSrc - 1] - data[indexSrc - strideSrc + 1];
                imgY[indexY++] = (short)(data[indexSrc + strideSrc] + w + v - data[indexSrc - strideSrc]);
                imgX[indexX++] = (short)(data[indexSrc + 1] + w - v - data[indexSrc - 1]);
            }
        }
    }

    public static void process(ImageFloat32 orig, ImageFloat32 derivX, ImageFloat32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int strideSrc = orig.getStride();
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int endX = indexSrc + width - 2;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            for (indexSrc = orig.startIndex + orig.stride * y + 1; indexSrc < endX; ++indexSrc) {
                float w = data[indexSrc + strideSrc + 1] - data[indexSrc - strideSrc - 1];
                float v = data[indexSrc + strideSrc - 1] - data[indexSrc - strideSrc + 1];
                imgY[indexY++] = data[indexSrc + strideSrc] + w + v - data[indexSrc - strideSrc];
                imgX[indexX++] = data[indexSrc + 1] + w - v - data[indexSrc - 1];
            }
        }
    }
}

