/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class ImplConvolveMean {
    public static void horizontal(ImageUInt8 input, ImageInt8 output, int radius, boolean includeBorder) {
        int kernelWidth = radius * 2 + 1;
        int startY = includeBorder ? 0 : radius;
        int endY = includeBorder ? input.height : input.height - radius;
        int divisor = kernelWidth;
        int halfDivisor = divisor / 2;
        for (int y = startY; y < endY; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = (byte)((total + halfDivisor) / divisor);
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFF;
                output.data[indexOut++] = (byte)(((total += input.data[indexIn] & 0xFF) + halfDivisor) / divisor);
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageUInt8 input, ImageInt8 output, int radius, boolean includeBorder) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int startX = includeBorder ? 0 : radius;
        int endX = includeBorder ? input.width : input.width - radius;
        int backStep = kernelWidth * input.stride;
        int divisor = kernelWidth;
        int halfDivisor = divisor / 2;
        int[] totals = new int[input.width];
        for (int x = startX; x < endX; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn] & 0xFF;
            }
            totals[x] = total;
            output.data[indexOut] = (byte)((total + halfDivisor) / divisor);
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            int x = startX;
            while (x < endX) {
                int total = totals[x] - (input.data[indexIn - backStep] & 0xFF);
                totals[x] = total += input.data[indexIn] & 0xFF;
                output.data[indexOut] = (byte)((total + halfDivisor) / divisor);
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(ImageSInt16 input, ImageInt16 output, int radius, boolean includeBorder) {
        int kernelWidth = radius * 2 + 1;
        int startY = includeBorder ? 0 : radius;
        int endY = includeBorder ? input.height : input.height - radius;
        int divisor = kernelWidth;
        int halfDivisor = divisor / 2;
        for (int y = startY; y < endY; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = (short)((total + halfDivisor) / divisor);
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = (short)(((total += input.data[indexIn]) + halfDivisor) / divisor);
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageSInt16 input, ImageInt16 output, int radius, boolean includeBorder) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int startX = includeBorder ? 0 : radius;
        int endX = includeBorder ? input.width : input.width - radius;
        int backStep = kernelWidth * input.stride;
        int divisor = kernelWidth;
        int halfDivisor = divisor / 2;
        int[] totals = new int[input.width];
        for (int x = startX; x < endX; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            totals[x] = total;
            output.data[indexOut] = (short)((total + halfDivisor) / divisor);
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            int x = startX;
            while (x < endX) {
                int total = totals[x] - input.data[indexIn - backStep];
                totals[x] = total += input.data[indexIn];
                output.data[indexOut] = (short)((total + halfDivisor) / divisor);
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(ImageFloat32 input, ImageFloat32 output, int radius, boolean includeBorder) {
        int kernelWidth = radius * 2 + 1;
        int startY = includeBorder ? 0 : radius;
        int endY = includeBorder ? input.height : input.height - radius;
        float divisor = kernelWidth;
        for (int y = startY; y < endY; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            float total = 0.0f;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total / divisor;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = (total += input.data[indexIn]) / divisor;
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageFloat32 input, ImageFloat32 output, int radius, boolean includeBorder) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int startX = includeBorder ? 0 : radius;
        int endX = includeBorder ? input.width : input.width - radius;
        int backStep = kernelWidth * input.stride;
        float divisor = kernelWidth;
        float[] totals = new float[input.width];
        for (int x = startX; x < endX; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            float total = 0.0f;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            totals[x] = total;
            output.data[indexOut] = total / divisor;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            int x = startX;
            while (x < endX) {
                float total = totals[x] - input.data[indexIn - backStep];
                totals[x] = total += input.data[indexIn];
                output.data[indexOut] = total / divisor;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }
}

