/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.border;

import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt32;

public class ConvolveJustBorder_General {
    public static void horizontal(Kernel1D_F32 kernel, ImageBorder_F32 input, ImageFloat32 output, int border) {
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int k;
            float total;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < border; ++x) {
                total = 0.0f;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x + k, y) * dataKer[k + radius];
                }
                dataDst[indexDest++] = total;
            }
            indexDest = output.startIndex + y * output.stride + width - border;
            for (x = width - border; x < width; ++x) {
                total = 0.0f;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x + k, y) * dataKer[k + radius];
                }
                dataDst[indexDest++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, ImageBorder_F32 input, ImageFloat32 output, int border) {
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int x = 0; x < width; ++x) {
            int k;
            float total;
            int indexDest = output.startIndex + x;
            int y = 0;
            while (y < border) {
                total = 0.0f;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x, y + k) * dataKer[k + radius];
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - border) * output.stride + x;
            y = height - border;
            while (y < height) {
                total = 0.0f;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x, y + k) * dataKer[k + radius];
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, ImageBorder_F32 input, ImageFloat32 output, int border) {
        int j;
        int i;
        int indexKer;
        float total;
        int indexDest;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int x;
            indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < border; ++x) {
                total = 0.0f;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = total;
            }
            indexDest = output.startIndex + y * output.stride + width - border;
            for (x = width - border; x < width; ++x) {
                total = 0.0f;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = total;
            }
        }
        for (int x = border; x < width - border; ++x) {
            indexDest = output.startIndex + x;
            int y = 0;
            while (y < border) {
                total = 0.0f;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - border) * output.stride + x;
            y = height - border;
            while (y < height) {
                total = 0.0f;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageBorder_I32 input, ImageInt16 output, int border) {
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int k;
            int total;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < border; ++x) {
                total = 0;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x + k, y) * dataKer[k + radius];
                }
                dataDst[indexDest++] = (short)total;
            }
            indexDest = output.startIndex + y * output.stride + width - border;
            for (x = width - border; x < width; ++x) {
                total = 0;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x + k, y) * dataKer[k + radius];
                }
                dataDst[indexDest++] = (short)total;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageBorder_I32 input, ImageInt16 output, int border) {
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int x = 0; x < width; ++x) {
            int k;
            int total;
            int indexDest = output.startIndex + x;
            int y = 0;
            while (y < border) {
                total = 0;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x, y + k) * dataKer[k + radius];
                }
                dataDst[indexDest] = (short)total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - border) * output.stride + x;
            y = height - border;
            while (y < height) {
                total = 0;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x, y + k) * dataKer[k + radius];
                }
                dataDst[indexDest] = (short)total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageBorder_I32 input, ImageInt16 output, int border) {
        int j;
        int i;
        int indexKer;
        int total;
        int indexDest;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int x;
            indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < border; ++x) {
                total = 0;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = (short)total;
            }
            indexDest = output.startIndex + y * output.stride + width - border;
            for (x = width - border; x < width; ++x) {
                total = 0;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = (short)total;
            }
        }
        for (int x = border; x < width - border; ++x) {
            indexDest = output.startIndex + x;
            int y = 0;
            while (y < border) {
                total = 0;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = (short)total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - border) * output.stride + x;
            y = height - border;
            while (y < height) {
                total = 0;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = (short)total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageBorder_I32 input, ImageSInt32 output, int border) {
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int k;
            int total;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < border; ++x) {
                total = 0;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x + k, y) * dataKer[k + radius];
                }
                dataDst[indexDest++] = total;
            }
            indexDest = output.startIndex + y * output.stride + width - border;
            for (x = width - border; x < width; ++x) {
                total = 0;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x + k, y) * dataKer[k + radius];
                }
                dataDst[indexDest++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageBorder_I32 input, ImageSInt32 output, int border) {
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int x = 0; x < width; ++x) {
            int k;
            int total;
            int indexDest = output.startIndex + x;
            int y = 0;
            while (y < border) {
                total = 0;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x, y + k) * dataKer[k + radius];
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - border) * output.stride + x;
            y = height - border;
            while (y < height) {
                total = 0;
                for (k = -radius; k <= radius; ++k) {
                    total += input.get(x, y + k) * dataKer[k + radius];
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageBorder_I32 input, ImageSInt32 output, int border) {
        int j;
        int i;
        int indexKer;
        int total;
        int indexDest;
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int x;
            indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < border; ++x) {
                total = 0;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = total;
            }
            indexDest = output.startIndex + y * output.stride + width - border;
            for (x = width - border; x < width; ++x) {
                total = 0;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = total;
            }
        }
        for (int x = border; x < width - border; ++x) {
            indexDest = output.startIndex + x;
            int y = 0;
            while (y < border) {
                total = 0;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - border) * output.stride + x;
            y = height - border;
            while (y < height) {
                total = 0;
                indexKer = 0;
                for (i = -radius; i <= radius; ++i) {
                    for (j = -radius; j <= radius; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
        }
    }
}

