/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.BoofDefaults;
import boofcv.struct.image.ImageSingleBand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ImageHessian_Reflection<Output extends ImageSingleBand>
implements ImageHessian<Output> {
    BorderType borderType = BoofDefaults.DERIV_BORDER_TYPE;
    ImageBorder<Output> border;
    private Method m;

    public ImageHessian_Reflection(Method m) {
        this.m = m;
        this.setBorderType(this.borderType);
    }

    @Override
    public void process(Output inputDerivX, Output inputDerivY, Output derivXX, Output derivYY, Output derivXY) {
        try {
            this.m.invoke(null, inputDerivX, inputDerivY, derivXX, derivYY, derivXY, this.border);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderType = type;
        Class<?> imageType = this.m.getParameterTypes()[0];
        this.border = FactoryImageBorder.general(imageType, this.borderType);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderType;
    }

    @Override
    public int getBorder() {
        if (this.borderType != BorderType.SKIP) {
            return 0;
        }
        return 1;
    }

    @Override
    public Class<Output> getDerivType() {
        return this.m.getParameterTypes()[2];
    }
}

