/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.BoofDefaults;
import boofcv.struct.image.ImageSingleBand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ImageGradient_Reflection<Input extends ImageSingleBand, Output extends ImageSingleBand>
implements ImageGradient<Input, Output> {
    BorderType borderType = BoofDefaults.DERIV_BORDER_TYPE;
    ImageBorder<Input> border;
    private Method m;

    public ImageGradient_Reflection(Method m) {
        this.m = m;
        this.setBorderType(this.borderType);
    }

    @Override
    public void process(Input inputImage, Output derivX, Output derivY) {
        try {
            this.m.invoke(null, inputImage, derivX, derivY, this.border);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderType = type;
        Class<?> imageType = this.m.getParameterTypes()[0];
        this.border = FactoryImageBorder.general(imageType, this.borderType);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderType;
    }

    @Override
    public int getBorder() {
        if (this.borderType != BorderType.SKIP) {
            return 0;
        }
        return 1;
    }

    @Override
    public Class<Output> getDerivType() {
        return this.m.getParameterTypes()[1];
    }
}

