/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.disparity;

import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.abst.feature.disparity.StereoDisparitySparse;
import boofcv.abst.feature.disparity.WrapDisparitySadRect;
import boofcv.abst.feature.disparity.WrapDisparitySparseSadRect;
import boofcv.alg.feature.disparity.DisparityScoreRowFormat;
import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.alg.feature.disparity.DisparitySparseScoreSadRect;
import boofcv.alg.feature.disparity.DisparitySparseSelect;
import boofcv.factory.feature.disparity.DisparityAlgorithms;
import boofcv.factory.feature.disparity.FactoryStereoDisparityAlgs;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class FactoryStereoDisparity {
    public static <T extends ImageSingleBand> StereoDisparity<T, ImageUInt8> regionWta(DisparityAlgorithms whichAlg, int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, double maxPerPixelError, int validateRtoL, double texture, Class<T> imageType) {
        DisparitySelect<int[], ImageUInt8> select;
        double maxError = (double)((regionRadiusX * 2 + 1) * (regionRadiusY * 2 + 1)) * maxPerPixelError;
        if (whichAlg == DisparityAlgorithms.RECT_FIVE) {
            maxError *= 3.0;
        }
        if (imageType == ImageUInt8.class || imageType == ImageSInt16.class) {
            select = FactoryStereoDisparityAlgs.selectDisparity_S32((int)maxError, validateRtoL, texture);
        } else if (imageType == ImageFloat32.class) {
            select = FactoryStereoDisparityAlgs.selectDisparity_F32((int)maxError, validateRtoL, texture);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
        DisparityScoreRowFormat alg = null;
        switch (whichAlg) {
            case RECT: {
                if (imageType == ImageUInt8.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType == ImageSInt16.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_S16(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType != ImageFloat32.class) break;
                alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                break;
            }
            case RECT_FIVE: {
                if (imageType == ImageUInt8.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType == ImageSInt16.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_S16(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType != ImageFloat32.class) break;
                alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithms " + (Object)((Object)whichAlg));
            }
        }
        if (alg == null) {
            throw new RuntimeException("Image type not supported: " + imageType.getSimpleName());
        }
        return new WrapDisparitySadRect<ImageUInt8, ImageUInt8>(alg);
    }

    public static <T extends ImageSingleBand> StereoDisparity<T, ImageFloat32> regionSubpixelWta(DisparityAlgorithms whichAlg, int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, double maxPerPixelError, int validateRtoL, double texture, Class<T> imageType) {
        DisparitySelect<int[], ImageFloat32> select;
        double maxError = (double)((regionRadiusX * 2 + 1) * (regionRadiusY * 2 + 1)) * maxPerPixelError;
        if (whichAlg == DisparityAlgorithms.RECT_FIVE) {
            maxError *= 3.0;
        }
        if (imageType == ImageUInt8.class || imageType == ImageSInt16.class) {
            select = FactoryStereoDisparityAlgs.selectDisparitySubpixel_S32((int)maxError, validateRtoL, texture);
        } else if (imageType == ImageFloat32.class) {
            select = FactoryStereoDisparityAlgs.selectDisparitySubpixel_F32((int)maxError, validateRtoL, texture);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
        DisparityScoreRowFormat alg = null;
        switch (whichAlg) {
            case RECT: {
                if (imageType == ImageUInt8.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType == ImageSInt16.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_S16(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType != ImageFloat32.class) break;
                alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                break;
            }
            case RECT_FIVE: {
                if (imageType == ImageUInt8.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType == ImageSInt16.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_S16(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType != ImageFloat32.class) break;
                alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithms " + (Object)((Object)whichAlg));
            }
        }
        if (alg == null) {
            throw new RuntimeException("Image type not supported: " + imageType.getSimpleName());
        }
        return new WrapDisparitySadRect<ImageUInt8, ImageFloat32>(alg);
    }

    public static <T extends ImageSingleBand> StereoDisparitySparse<T> regionSparseWta(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, double maxPerPixelError, double texture, boolean subpixelInterpolation, Class<T> imageType) {
        double maxError = (double)((regionRadiusX * 2 + 1) * (regionRadiusY * 2 + 1)) * maxPerPixelError;
        if (imageType == ImageUInt8.class) {
            DisparitySparseSelect<int[]> select = subpixelInterpolation ? FactoryStereoDisparityAlgs.selectDisparitySparseSubpixel_S32((int)maxError, texture) : FactoryStereoDisparityAlgs.selectDisparitySparse_S32((int)maxError, texture);
            DisparitySparseScoreSadRect<int[], ImageUInt8> score = FactoryStereoDisparityAlgs.scoreDisparitySparseSadRect_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
            return new WrapDisparitySparseSadRect<int[], ImageUInt8>(score, select);
        }
        if (imageType == ImageFloat32.class) {
            DisparitySparseSelect<float[]> select = subpixelInterpolation ? FactoryStereoDisparityAlgs.selectDisparitySparseSubpixel_F32((int)maxError, texture) : FactoryStereoDisparityAlgs.selectDisparitySparse_F32((int)maxError, texture);
            DisparitySparseScoreSadRect<float[], ImageFloat32> score = FactoryStereoDisparityAlgs.scoreDisparitySparseSadRect_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
            return new WrapDisparitySparseSadRect<float[], ImageFloat32>(score, select);
        }
        throw new RuntimeException("Image type not supported: " + imageType.getSimpleName());
    }
}

