/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.intensity.WrapperFastCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperKitRosCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperMedianCornerIntensity;
import boofcv.abst.feature.detect.interest.ConfigFast;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.filter.blur.MedianImageFilter;
import boofcv.alg.feature.detect.intensity.FastCornerIntensity;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.intensity.HarrisCornerIntensity;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.feature.detect.intensity.ShiTomasiCornerIntensity;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPoint;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.image.ImageSingleBand;

public class FactoryDetectPoint {
    public static <T extends ImageSingleBand, D extends ImageSingleBand> GeneralFeatureDetector<T, D> createHarris(ConfigGeneralDetector configDetector, boolean weighted, Class<D> derivType) {
        HarrisCornerIntensity<D> cornerIntensity = FactoryIntensityPointAlg.harris(configDetector.radius, 0.04f, weighted, derivType);
        return FactoryDetectPoint.createGeneral(cornerIntensity, configDetector);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> GeneralFeatureDetector<T, D> createShiTomasi(ConfigGeneralDetector configDetector, boolean weighted, Class<D> derivType) {
        ShiTomasiCornerIntensity<D> cornerIntensity = FactoryIntensityPointAlg.shiTomasi(configDetector.radius, weighted, derivType);
        return FactoryDetectPoint.createGeneral(cornerIntensity, configDetector);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> GeneralFeatureDetector<T, D> createKitRos(ConfigGeneralDetector configDetector, Class<D> derivType) {
        WrapperKitRosCornerIntensity intensity = new WrapperKitRosCornerIntensity(derivType);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> GeneralFeatureDetector<T, D> createFast(ConfigFast configFast, ConfigGeneralDetector configDetector, Class<T> imageType) {
        if (configFast == null) {
            configFast = new ConfigFast();
        }
        configFast.checkValidity();
        ConfigGeneralDetector d = configDetector;
        FastCornerIntensity<T> alg = FactoryIntensityPointAlg.fast(configFast.pixelTol, configFast.minContinuous, imageType);
        WrapperFastCornerIntensity intensity = new WrapperFastCornerIntensity(alg);
        ConfigGeneralDetector configExtract = new ConfigGeneralDetector(d.maxFeatures, d.radius, d.threshold, 0, true, false, true);
        return FactoryDetectPoint.createGeneral(intensity, configExtract);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> GeneralFeatureDetector<T, D> createMedian(ConfigGeneralDetector configDetector, Class<T> imageType) {
        MedianImageFilter medianFilter = FactoryBlurFilter.median(imageType, (int)configDetector.radius);
        WrapperMedianCornerIntensity intensity = new WrapperMedianCornerIntensity(medianFilter, imageType);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> GeneralFeatureDetector<T, D> createHessian(HessianBlobIntensity.Type type, ConfigGeneralDetector configDetector, Class<D> derivType) {
        GeneralFeatureIntensity intensity = FactoryIntensityPoint.hessian(type, derivType);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> GeneralFeatureDetector<T, D> createGeneral(GradientCornerIntensity<D> cornerIntensity, ConfigGeneralDetector config) {
        WrapperGradientCornerIntensity intensity = new WrapperGradientCornerIntensity(cornerIntensity);
        return FactoryDetectPoint.createGeneral(intensity, config);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> GeneralFeatureDetector<T, D> createGeneral(GeneralFeatureIntensity<T, D> intensity, ConfigGeneralDetector config) {
        config.ignoreBorder += config.radius;
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(config);
        GeneralFeatureDetector<T, D> det = new GeneralFeatureDetector<T, D>(intensity, extractor);
        det.setMaxFeatures(config.maxFeatures);
        return det;
    }
}

