/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.klt;

import boofcv.alg.tracker.klt.KltFeature;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.KltTracker;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;

public class PyramidKltTracker<InputImage extends ImageSingleBand, DerivativeImage extends ImageSingleBand> {
    protected KltTracker<InputImage, DerivativeImage> tracker;
    protected ImagePyramid<InputImage> image;
    protected DerivativeImage[] derivX;
    protected DerivativeImage[] derivY;

    public PyramidKltTracker(KltTracker<InputImage, DerivativeImage> tracker) {
        this.tracker = tracker;
    }

    public boolean setDescription(PyramidKltFeature feature) {
        for (int layer = 0; layer < this.image.getNumLayers(); ++layer) {
            float scale = (float)this.image.getScale(layer);
            float x = feature.x / scale;
            float y = feature.y / scale;
            this.setupKltTracker(layer);
            feature.desc[layer].setPosition(x, y);
            if (this.tracker.setDescription(feature.desc[layer])) continue;
            return false;
        }
        return true;
    }

    public void setImage(ImagePyramid<InputImage> image, DerivativeImage[] derivX, DerivativeImage[] derivY) {
        if (image.getNumLayers() != derivX.length || image.getNumLayers() != derivY.length) {
            throw new IllegalArgumentException("Number of layers does not match.");
        }
        this.image = image;
        this.derivX = derivX;
        this.derivY = derivY;
    }

    public KltTrackFault track(PyramidKltFeature feature) {
        int firstLevelTracked = -1;
        float x = feature.x;
        float y = feature.y;
        for (int layer = this.image.getNumLayers() - 1; layer >= 0; --layer) {
            float scale = (float)this.image.getScale(layer);
            this.setupKltTracker(layer);
            KltFeature f = feature.desc[layer];
            f.setPosition(x /= scale, y /= scale);
            KltTrackFault ret = this.tracker.track(f);
            if (ret == KltTrackFault.SUCCESS) {
                if (firstLevelTracked == -1) {
                    firstLevelTracked = layer;
                }
            } else {
                return ret;
            }
            x = feature.desc[layer].x;
            y = feature.desc[layer].y;
            x *= scale;
            y *= scale;
        }
        feature.setPosition(x, y);
        return KltTrackFault.SUCCESS;
    }

    private void setupKltTracker(int layer) {
        if (this.derivX != null) {
            this.tracker.setImage((ImageSingleBand)this.image.getLayer(layer), this.derivX[layer], this.derivY[layer]);
        } else {
            this.tracker.setImage((ImageSingleBand)this.image.getLayer(layer), null, null);
        }
    }
}

