/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.impl.ImplSelectRectStandardBase_F32;
import boofcv.alg.feature.disparity.impl.ImplSelectRectStandardBase_S32;
import boofcv.struct.image.ImageFloat32;

public class SelectRectSubpixel {

    public static class F32_F32
    extends ImplSelectRectStandardBase_F32<ImageFloat32> {
        public F32_F32(int maxError, int rightToLeftTolerance, double texture) {
            super(maxError, rightToLeftTolerance, texture);
        }

        @Override
        protected void setDisparity(int index, int disparityValue) {
            if (disparityValue <= 0 || disparityValue >= this.localMax - 1) {
                ((ImageFloat32)this.imageDisparity).data[index] = disparityValue;
            } else {
                float c0 = this.columnScore[disparityValue - 1];
                float c1 = this.columnScore[disparityValue];
                float c2 = this.columnScore[disparityValue + 1];
                float offset = (c0 - c2) / (2.0f * (c0 - 2.0f * c1 + c2));
                ((ImageFloat32)this.imageDisparity).data[index] = (float)disparityValue + offset;
            }
        }

        @Override
        public Class<ImageFloat32> getDisparityType() {
            return ImageFloat32.class;
        }
    }

    public static class S32_F32
    extends ImplSelectRectStandardBase_S32<ImageFloat32> {
        public S32_F32(int maxError, int rightToLeftTolerance, double texture) {
            super(maxError, rightToLeftTolerance, texture);
        }

        @Override
        protected void setDisparity(int index, int disparityValue) {
            if (disparityValue <= 0 || disparityValue >= this.localMax - 1) {
                ((ImageFloat32)this.imageDisparity).data[index] = disparityValue;
            } else {
                int c0 = this.columnScore[disparityValue - 1];
                int c1 = this.columnScore[disparityValue];
                int c2 = this.columnScore[disparityValue + 1];
                float offset = (float)(c0 - c2) / (float)(2 * (c0 - 2 * c1 + c2));
                ((ImageFloat32)this.imageDisparity).data[index] = (float)disparityValue + offset;
            }
        }

        @Override
        public Class<ImageFloat32> getDisparityType() {
            return ImageFloat32.class;
        }
    }
}

