/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.template;

import boofcv.alg.feature.detect.template.BaseTemplateIntensity;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;

public abstract class TemplateNCC<T extends ImageBase>
extends BaseTemplateIntensity<T> {
    @Override
    public void process(T image, T template) {
        this.setupTemplate(template);
        super.process(image, template);
    }

    public abstract void setupTemplate(T var1);

    @Override
    public boolean isBorderProcessed() {
        return false;
    }

    public static class U8
    extends TemplateNCC<ImageUInt8> {
        float area;
        float templateMean;
        float templateSigma;

        @Override
        protected float evaluate(int tl_x, int tl_y) {
            int imageIndex;
            int y;
            float top = 0.0f;
            float imageMean = 0.0f;
            float imageSigma = 0.0f;
            for (y = 0; y < ((ImageUInt8)this.template).height; ++y) {
                imageIndex = ((ImageUInt8)this.image).startIndex + (tl_y + y) * ((ImageUInt8)this.image).stride + tl_x;
                for (int x = 0; x < ((ImageUInt8)this.template).width; ++x) {
                    imageMean += (float)(((ImageUInt8)this.image).data[imageIndex++] & 0xFF);
                }
            }
            imageMean /= this.area;
            for (y = 0; y < ((ImageUInt8)this.template).height; ++y) {
                imageIndex = ((ImageUInt8)this.image).startIndex + (tl_y + y) * ((ImageUInt8)this.image).stride + tl_x;
                int templateIndex = ((ImageUInt8)this.template).startIndex + y * ((ImageUInt8)this.template).stride;
                for (int x = 0; x < ((ImageUInt8)this.template).width; ++x) {
                    float templateVal = ((ImageUInt8)this.template).data[templateIndex++] & 0xFF;
                    float diff = (float)(((ImageUInt8)this.image).data[imageIndex++] & 0xFF) - imageMean;
                    imageSigma += diff * diff;
                    top += diff * (templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma / this.area);
            return top / (imageSigma * this.templateSigma);
        }

        @Override
        public void setupTemplate(ImageUInt8 template) {
            int x;
            int templateIndex;
            int y;
            this.area = template.width * template.height;
            this.templateMean = 0.0f;
            for (y = 0; y < template.height; ++y) {
                templateIndex = template.startIndex + y * template.stride;
                for (x = 0; x < template.width; ++x) {
                    this.templateMean += (float)(template.data[templateIndex++] & 0xFF);
                }
            }
            this.templateMean /= this.area;
            this.templateSigma = 0.0f;
            for (y = 0; y < template.height; ++y) {
                templateIndex = template.startIndex + y * template.stride;
                for (x = 0; x < template.width; ++x) {
                    float diff = (float)(template.data[templateIndex++] & 0xFF) - this.templateMean;
                    this.templateSigma += diff * diff;
                }
            }
            this.templateSigma = (float)Math.sqrt(this.templateSigma / this.area);
        }
    }

    public static class F32
    extends TemplateNCC<ImageFloat32> {
        float area;
        float templateMean;
        float templateSigma;

        @Override
        protected float evaluate(int tl_x, int tl_y) {
            int imageIndex;
            int y;
            float top = 0.0f;
            float imageMean = 0.0f;
            float imageSigma = 0.0f;
            for (y = 0; y < ((ImageFloat32)this.template).height; ++y) {
                imageIndex = ((ImageFloat32)this.image).startIndex + (tl_y + y) * ((ImageFloat32)this.image).stride + tl_x;
                for (int x = 0; x < ((ImageFloat32)this.template).width; ++x) {
                    imageMean += ((ImageFloat32)this.image).data[imageIndex++];
                }
            }
            imageMean /= this.area;
            for (y = 0; y < ((ImageFloat32)this.template).height; ++y) {
                imageIndex = ((ImageFloat32)this.image).startIndex + (tl_y + y) * ((ImageFloat32)this.image).stride + tl_x;
                int templateIndex = ((ImageFloat32)this.template).startIndex + y * ((ImageFloat32)this.template).stride;
                for (int x = 0; x < ((ImageFloat32)this.template).width; ++x) {
                    float templateVal = ((ImageFloat32)this.template).data[templateIndex++];
                    float diff = ((ImageFloat32)this.image).data[imageIndex++] - imageMean;
                    imageSigma += diff * diff;
                    top += diff * (templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma / this.area);
            return top / (imageSigma * this.templateSigma);
        }

        @Override
        public void setupTemplate(ImageFloat32 template) {
            int x;
            int templateIndex;
            int y;
            this.area = template.width * template.height;
            this.templateMean = 0.0f;
            for (y = 0; y < template.height; ++y) {
                templateIndex = template.startIndex + y * template.stride;
                for (x = 0; x < template.width; ++x) {
                    this.templateMean += template.data[templateIndex++];
                }
            }
            this.templateMean /= this.area;
            this.templateSigma = 0.0f;
            for (y = 0; y < template.height; ++y) {
                templateIndex = template.startIndex + y * template.stride;
                for (x = 0; x < template.width; ++x) {
                    float diff = template.data[templateIndex++] - this.templateMean;
                    this.templateSigma += diff * diff;
                }
            }
            this.templateSigma = (float)Math.sqrt(this.templateSigma / this.area);
        }
    }
}

