/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.template;

import boofcv.alg.feature.detect.template.TemplateMatchingIntensity;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;

public abstract class BaseTemplateIntensity<T extends ImageBase>
implements TemplateMatchingIntensity<T> {
    private ImageFloat32 intensity = new ImageFloat32(1, 1);
    protected T image;
    protected T template;
    private int offsetX;
    private int offsetY;

    @Override
    public void process(T image, T template) {
        this.image = image;
        this.template = template;
        this.intensity.reshape(((ImageBase)image).width, ((ImageBase)image).height);
        int w = ((ImageBase)image).width - ((ImageBase)template).width;
        int h = ((ImageBase)image).height - ((ImageBase)template).height;
        this.offsetX = ((ImageBase)template).width / 2;
        this.offsetY = ((ImageBase)template).height / 2;
        for (int y = 0; y < h; ++y) {
            int index = this.intensity.startIndex + (y + this.offsetY) * this.intensity.stride + this.offsetX;
            for (int x = 0; x < w; ++x) {
                this.intensity.data[index++] = this.evaluate(x, y);
            }
        }
    }

    protected abstract float evaluate(int var1, int var2);

    @Override
    public ImageFloat32 getIntensity() {
        return this.intensity;
    }

    @Override
    public int getOffsetX() {
        return this.offsetX;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }
}

