/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.peak;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageSingleBand;

public abstract class MeanShiftPeak<T extends ImageSingleBand> {
    protected T image;
    protected InterpolatePixelS<T> interpolate;
    protected int maxIterations;
    protected int radius;
    protected int width;
    protected float convergenceTol;
    protected float peakX;
    protected float peakY;
    protected float x0;
    protected float y0;

    public MeanShiftPeak(int maxIterations, float convergenceTol, int radius, Class<T> imageType) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.radius = radius;
        this.width = radius * 2 + 1;
        this.interpolate = FactoryInterpolation.bilinearPixelS(imageType);
    }

    public void setImage(T image) {
        this.image = image;
        this.interpolate.setImage(image);
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.width = radius * 2 + 1;
    }

    public abstract void search(float var1, float var2);

    protected void setRegion(float cx, float cy) {
        this.x0 = cx - (float)this.radius;
        this.y0 = cy - (float)this.radius;
        if (this.x0 < 0.0f) {
            this.x0 = 0.0f;
        } else if (this.x0 + (float)this.width > (float)((ImageSingleBand)this.image).width) {
            this.x0 = ((ImageSingleBand)this.image).width - this.width;
        }
        if (this.y0 < 0.0f) {
            this.y0 = 0.0f;
        } else if (this.y0 + (float)this.width > (float)((ImageSingleBand)this.image).height) {
            this.y0 = ((ImageSingleBand)this.image).height - this.width;
        }
    }

    public float getPeakX() {
        return this.peakX;
    }

    public float getPeakY() {
        return this.peakY;
    }
}

