/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.peak;

import boofcv.alg.feature.detect.peak.MeanShiftPeak;
import boofcv.alg.filter.kernel.KernelMath;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.ImageSingleBand;

public class MeanShiftGaussianPeak<T extends ImageSingleBand>
extends MeanShiftPeak<T> {
    protected Kernel2D_F32 kernel;

    public MeanShiftGaussianPeak(int maxIterations, float convergenceTol, int radius, Class<T> imageType) {
        super(maxIterations, convergenceTol, radius, imageType);
    }

    @Override
    public void setRadius(int radius) {
        super.setRadius(radius);
        if (this.kernel == null || this.kernel.getRadius() != radius) {
            this.kernel = (Kernel2D_F32)FactoryKernelGaussian.gaussian((int)2, (boolean)true, (int)32, (double)-1.0, (int)radius);
            float max = KernelMath.maxAbs((float[])this.kernel.data, (int)this.kernel.data.length);
            int i = 0;
            while (i < this.kernel.data.length) {
                int n = i++;
                this.kernel.data[n] = this.kernel.data[n] / max;
            }
        }
    }

    @Override
    public void search(float cx, float cy) {
        this.peakX = cx;
        this.peakY = cy;
        this.setRegion(cx, cy);
        for (int i = 0; i < this.maxIterations; ++i) {
            float weight;
            float w;
            int yy;
            float total = 0.0f;
            float sumX = 0.0f;
            float sumY = 0.0f;
            int kernelIndex = 0;
            if (this.interpolate.isInFastBounds(this.x0, this.y0) && this.interpolate.isInFastBounds(this.x0 + (float)this.width - 1.0f, this.y0 + (float)this.width - 1.0f)) {
                for (yy = 0; yy < this.width; ++yy) {
                    for (int xx = 0; xx < this.width; ++xx) {
                        w = this.kernel.data[kernelIndex++];
                        weight = w * this.interpolate.get_fast(this.x0 + (float)xx, this.y0 + (float)yy);
                        total += weight;
                        sumX += weight * ((float)xx + this.x0);
                        sumY += weight * ((float)yy + this.y0);
                    }
                }
            } else {
                for (yy = 0; yy < this.width; ++yy) {
                    for (int xx = 0; xx < this.width; ++xx) {
                        w = this.kernel.data[kernelIndex++];
                        weight = w * this.interpolate.get(this.x0 + (float)xx, this.y0 + (float)yy);
                        total += weight;
                        sumX += weight * ((float)xx + this.x0);
                        sumY += weight * ((float)yy + this.y0);
                    }
                }
            }
            cx = sumX / total;
            cy = sumY / total;
            this.setRegion(cx, cy);
            float dx = cx - this.peakX;
            float dy = cy - this.peakY;
            this.peakX = cx;
            this.peakY = cy;
            if (Math.abs(dx) < this.convergenceTol && Math.abs(dy) < this.convergenceTol) break;
        }
    }
}

