/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.alg.misc.PixelMath;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;

public class SiftImageScaleSpace {
    protected int numOctaves;
    protected int numScales;
    protected int actualOctaves;
    protected ImageFloat32[] dog;
    protected ImageFloat32[] scale;
    protected ImageFloat32[] derivX;
    protected ImageFloat32[] derivY;
    protected float sigma;
    protected double[] pixelScale;
    protected double[] layerSigma;
    private boolean doubleInputImage;
    private double[] priorSigmaFirstScale;
    private ImageGradient<ImageFloat32, ImageFloat32> gradient = FactoryDerivative.three_F32();
    protected ImageFloat32 storage;

    public SiftImageScaleSpace(float blurSigma, int numScales, int numOctaves, boolean doubleInputImage) {
        int i;
        double firstScale;
        if (numScales < 3) {
            throw new IllegalArgumentException("A minimum of 3 scales are required");
        }
        if (numOctaves < 1) {
            throw new IllegalArgumentException("At least one octave is required");
        }
        this.numOctaves = numOctaves;
        this.numScales = numScales;
        this.sigma = blurSigma;
        this.doubleInputImage = doubleInputImage;
        this.pixelScale = new double[numOctaves];
        this.priorSigmaFirstScale = new double[numOctaves];
        this.pixelScale[0] = firstScale = doubleInputImage ? 0.5 : 1.0;
        this.priorSigmaFirstScale[0] = 0.0;
        for (int o = 1; o < numOctaves; ++o) {
            this.pixelScale[o] = this.pixelScale[o - 1] * 2.0;
            this.priorSigmaFirstScale[o] = this.computeScaleSigma(o - 1, 1);
        }
        int totalImages = numScales * numOctaves;
        this.scale = new ImageFloat32[totalImages];
        this.derivX = new ImageFloat32[totalImages];
        this.derivY = new ImageFloat32[totalImages];
        this.dog = new ImageFloat32[totalImages - numOctaves];
        for (i = 0; i < this.scale.length; ++i) {
            this.scale[i] = new ImageFloat32(1, 1);
            this.derivX[i] = new ImageFloat32(1, 1);
            this.derivY[i] = new ImageFloat32(1, 1);
        }
        for (i = 0; i < this.dog.length; ++i) {
            this.dog[i] = new ImageFloat32(1, 1);
        }
        this.storage = new ImageFloat32(1, 1);
        this.layerSigma = new double[totalImages];
        for (int o = 0; o < numOctaves; ++o) {
            for (int s = 0; s < numScales; ++s) {
                int index = o * numScales + s;
                this.layerSigma[index] = this.computeScaleSigma(o, s);
            }
        }
    }

    public void constructPyramid(ImageFloat32 input) {
        if (this.doubleInputImage) {
            this.reshapeToInput(input.width * 2, input.height * 2);
            SiftImageScaleSpace.upSample(input, this.scale[1]);
            this.blurImage(this.scale[1], this.scale[0], this.sigma);
        } else {
            this.reshapeToInput(input.width, input.height);
            this.blurImage(input, this.scale[0], this.sigma);
        }
        this.constructRestOfOctave(0);
        this.actualOctaves = this.numOctaves;
        for (int o = 1; o < this.numOctaves; ++o) {
            int indexSeed = (o - 1) * this.numScales + 1;
            int indexStart = o * this.numScales;
            if (Math.max(this.scale[indexStart].width, this.scale[indexStart].height) < 5) {
                this.actualOctaves = o;
                break;
            }
            SiftImageScaleSpace.downSample(this.scale[indexSeed], this.scale[indexStart + 1]);
            this.blurImage(this.scale[indexStart + 1], this.scale[indexStart], this.sigma);
            this.constructRestOfOctave(o);
        }
    }

    public void computeDerivatives() {
        int maxScales = this.actualOctaves * this.numScales;
        for (int i = 0; i < maxScales; ++i) {
            ImageFloat32 input = this.scale[i];
            ImageFloat32 dx = this.derivX[i];
            ImageFloat32 dy = this.derivY[i];
            dx.reshape(input.width, input.height);
            dy.reshape(input.width, input.height);
            this.gradient.process((ImageSingleBand)input, (ImageSingleBand)dx, (ImageSingleBand)dy);
        }
    }

    public double computeScaleSigma(int octave, int scale) {
        double a = this.priorSigmaFirstScale[octave];
        double b = this.pixelScale[octave] * (double)this.sigma * (double)(scale + 1);
        return Math.sqrt(a * a + b * b);
    }

    private void blurImage(ImageFloat32 input, ImageFloat32 output, double sigma) {
        Kernel1D_F32 kernel = (Kernel1D_F32)FactoryKernelGaussian.gaussian(Kernel1D_F32.class, (double)sigma, (int)-1);
        this.storage.reshape(input.width, input.height);
        ConvolveNormalized.horizontal((Kernel1D_F32)kernel, (ImageFloat32)input, (ImageFloat32)this.storage);
        ConvolveNormalized.vertical((Kernel1D_F32)kernel, (ImageFloat32)this.storage, (ImageFloat32)output);
    }

    public void computeFeatureIntensity() {
        int indexDog = 0;
        for (int o = 0; o < this.actualOctaves; ++o) {
            int i = 1;
            while (i < this.numScales) {
                int indexScale = o * this.numScales + i;
                PixelMath.subtract((ImageFloat32)this.scale[indexScale], (ImageFloat32)this.scale[indexScale - 1], (ImageFloat32)this.dog[indexDog]);
                double k = (double)(i + 1) / (double)i;
                double adjustment = k - 1.0;
                PixelMath.divide((ImageFloat32)this.dog[indexDog], (float)((float)adjustment), (ImageFloat32)this.dog[indexDog]);
                ++i;
                ++indexDog;
            }
        }
    }

    private void constructRestOfOctave(int octave) {
        int indexScales = octave * this.numScales + 1;
        int i = 1;
        while (i < this.numScales) {
            double sigmaA = this.sigma * (float)i;
            double sigmaB = this.sigma * (float)(i + 1);
            double amount = Math.sqrt(sigmaB * sigmaB - sigmaA * sigmaA);
            this.blurImage(this.scale[indexScales - 1], this.scale[indexScales], amount);
            ++i;
            ++indexScales;
        }
    }

    protected static void downSample(ImageFloat32 from, ImageFloat32 to) {
        for (int y = 0; y < to.height; ++y) {
            for (int x = 0; x < to.width; ++x) {
                to.unsafe_set(x, y, from.unsafe_get(x * 2 + 1, y * 2 + 1));
            }
        }
    }

    protected static void upSample(ImageFloat32 from, ImageFloat32 to) {
        for (int y = 0; y < from.height; ++y) {
            int yy = y * 2;
            int xx = 0;
            for (int x = 0; x < from.width; ++x) {
                float v = from.unsafe_get(x, y);
                to.unsafe_set(xx, yy, v);
                to.unsafe_set(xx, yy + 1, v);
                to.unsafe_set(++xx, yy, v);
                to.unsafe_set(xx, yy + 1, v);
                ++xx;
            }
        }
    }

    private void reshapeToInput(int width, int height) {
        int indexScales = 0;
        int indexDog = 0;
        for (int o = 0; o < this.numOctaves; ++o) {
            int n = 0;
            while (n < this.numScales) {
                this.scale[indexScales].reshape(width, height);
                ++n;
                ++indexScales;
            }
            n = 0;
            while (n < this.numScales - 1) {
                this.dog[indexDog].reshape(width, height);
                ++n;
                ++indexDog;
            }
            width /= 2;
            height /= 2;
        }
    }

    public int getNumOctaves() {
        return this.numOctaves;
    }

    public int getNumScales() {
        return this.numScales;
    }

    public ImageFloat32 getPyramidLayer(int index) {
        return this.scale[index];
    }

    public ImageFloat32 getDerivativeX(int index) {
        return this.derivX[index];
    }

    public ImageFloat32 getDerivativeY(int index) {
        return this.derivY[index];
    }

    public int scaleToImageIndex(double sigma) {
        int index = -1;
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < this.layerSigma.length; ++i) {
            double error = Math.abs(sigma - this.layerSigma[i]);
            if (!(error < bestScore)) continue;
            bestScore = error;
            index = i;
        }
        return index;
    }

    public double imageIndexToPixelScale(int imageIndex) {
        return this.pixelScale[imageIndex / this.numScales];
    }
}

