/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageSingleBand;

public class EasyGeneralFeatureDetector<T extends ImageSingleBand, D extends ImageSingleBand> {
    protected GeneralFeatureDetector<T, D> detector;
    protected ImageGradient<T, D> gradient;
    protected ImageHessian<D> hessian;
    protected D derivX;
    protected D derivY;
    protected D derivXX;
    protected D derivYY;
    protected D derivXY;

    public EasyGeneralFeatureDetector(GeneralFeatureDetector<T, D> detector, Class<T> imageType, Class<D> derivType) {
        this.detector = detector;
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        if (detector.getRequiresGradient() || detector.getRequiresHessian()) {
            this.gradient = FactoryDerivative.sobel(imageType, (Class)derivType);
        }
        if (detector.getRequiresHessian()) {
            this.hessian = FactoryDerivative.hessianSobel((Class)derivType);
        }
        this.declareDerivativeImages(this.gradient, this.hessian, derivType);
    }

    public EasyGeneralFeatureDetector(GeneralFeatureDetector<T, D> detector, ImageGradient<T, D> gradient, ImageHessian<D> hessian, Class<D> derivType) {
        this.detector = detector;
        this.gradient = gradient;
        this.hessian = hessian;
        this.declareDerivativeImages(gradient, hessian, derivType);
    }

    private void declareDerivativeImages(ImageGradient<T, D> gradient, ImageHessian<D> hessian, Class<D> derivType) {
        if (gradient != null || hessian != null) {
            this.derivX = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
            this.derivY = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
        }
        if (hessian != null) {
            this.derivXX = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
            this.derivYY = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
            this.derivXY = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
        }
    }

    public void detect(T input, QueueCorner exclude) {
        this.initializeDerivatives(input);
        if (this.detector.getRequiresGradient() || this.detector.getRequiresHessian()) {
            this.gradient.process(input, this.derivX, this.derivY);
        }
        if (this.detector.getRequiresHessian()) {
            this.hessian.process(this.derivX, this.derivY, this.derivXX, this.derivYY, this.derivXY);
        }
        this.detector.setExcludeMaximum(exclude);
        this.detector.process(input, this.derivX, this.derivY, this.derivXX, this.derivYY, this.derivXY);
    }

    private void initializeDerivatives(T input) {
        if (this.detector.getRequiresGradient() || this.detector.getRequiresHessian()) {
            this.derivX.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            this.derivY.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        }
        if (this.detector.getRequiresHessian()) {
            this.derivXX.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            this.derivYY.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
            this.derivXY.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        }
    }

    public GeneralFeatureDetector<T, D> getDetector() {
        return this.detector;
    }

    public QueueCorner getMaximums() {
        return this.detector.getMaximums();
    }

    public QueueCorner getMinimums() {
        return this.detector.getMinimums();
    }
}

