/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.impl.FastHelper;
import boofcv.struct.image.ImageUInt8;

public class ImplFastHelper_U8
implements FastHelper<ImageUInt8> {
    private ImageUInt8 image;
    private int pixelTol;
    private int lower;
    private int upper;
    private int centerValue;
    private int[] offsets;

    public ImplFastHelper_U8(int pixelTol) {
        this.pixelTol = pixelTol;
    }

    @Override
    public void setImage(ImageUInt8 image, int[] offsets) {
        this.image = image;
        this.offsets = offsets;
    }

    @Override
    public void setThresholds(int index) {
        this.centerValue = this.image.data[index] & 0xFF;
        this.lower = this.centerValue - this.pixelTol;
        this.upper = this.centerValue + this.pixelTol;
    }

    @Override
    public float scoreLower(int index) {
        int total = 0;
        int count = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            int v = this.image.data[index + this.offsets[i]] & 0xFF;
            if (v >= this.lower) continue;
            total += v;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return this.centerValue * count - total;
    }

    @Override
    public float scoreUpper(int index) {
        int total = 0;
        int count = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            int v = this.image.data[index + this.offsets[i]] & 0xFF;
            if (v <= this.upper) continue;
            total += v;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total - this.centerValue * count;
    }

    @Override
    public boolean checkPixelLower(int index) {
        return (this.image.data[index] & 0xFF) < this.lower;
    }

    @Override
    public boolean checkPixelUpper(int index) {
        return (this.image.data[index] & 0xFF) > this.upper;
    }
}

