/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.edge.GradientToEdgeFeatures;
import boofcv.alg.feature.detect.edge.HysteresisEdgeTraceMark;
import boofcv.alg.feature.detect.edge.HysteresisEdgeTracePoints;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class CannyEdge<T extends ImageSingleBand, D extends ImageSingleBand> {
    private BlurFilter<T> blur;
    private ImageGradient<T, D> gradient;
    private T blurred;
    private D derivX;
    private D derivY;
    private ImageFloat32 intensity = new ImageFloat32(1, 1);
    protected ImageFloat32 suppressed = new ImageFloat32(1, 1);
    private ImageFloat32 angle = new ImageFloat32(1, 1);
    private ImageSInt8 direction = new ImageSInt8(1, 1);
    private ImageUInt8 work = new ImageUInt8(1, 1);
    private HysteresisEdgeTracePoints hysteresisPts;
    private HysteresisEdgeTraceMark hysteresisMark;

    public CannyEdge(BlurFilter<T> blur, ImageGradient<T, D> gradient, boolean saveTrace) {
        this.blur = blur;
        this.gradient = gradient;
        Class imageType = blur.getInputType();
        Class derivType = gradient.getDerivType();
        this.blurred = GeneralizedImageOps.createSingleBand((Class)imageType, (int)1, (int)1);
        this.derivX = GeneralizedImageOps.createSingleBand((Class)derivType, (int)1, (int)1);
        this.derivY = GeneralizedImageOps.createSingleBand((Class)derivType, (int)1, (int)1);
        if (saveTrace) {
            this.hysteresisPts = new HysteresisEdgeTracePoints();
        } else {
            this.hysteresisMark = new HysteresisEdgeTraceMark();
        }
    }

    public void process(T input, float threshLow, float threshHigh, ImageUInt8 output) {
        if (this.hysteresisMark != null && output == null) {
            throw new IllegalArgumentException("An output image must be specified when configured to mark edge points");
        }
        this.blurred.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.derivX.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.derivY.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.intensity.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.suppressed.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.angle.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.direction.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.work.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.blur.process(input, this.blurred);
        this.gradient.process(this.blurred, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.intensity);
        GGradientToEdgeFeatures.direction(this.derivX, this.derivY, this.angle);
        GradientToEdgeFeatures.discretizeDirection4(this.angle, this.direction);
        GradientToEdgeFeatures.nonMaxSuppression4(this.intensity, this.direction, this.suppressed);
        this.performThresholding(threshLow, threshHigh, output);
    }

    protected void performThresholding(float threshLow, float threshHigh, ImageUInt8 output) {
        if (this.hysteresisPts != null) {
            this.hysteresisPts.process(this.suppressed, this.direction, threshLow, threshHigh);
            if (output != null) {
                ImageMiscOps.fill((ImageInt8)output, (int)0);
                for (EdgeContour e : this.hysteresisPts.getContours()) {
                    for (EdgeSegment s : e.segments) {
                        for (Point2D_I32 p : s.points) {
                            output.unsafe_set(p.x, p.y, 1);
                        }
                    }
                }
            }
        } else {
            this.hysteresisMark.process(this.suppressed, this.direction, threshLow, threshHigh, output);
        }
    }

    public List<EdgeContour> getContours() {
        return this.hysteresisPts.getContours();
    }
}

