/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.feature.detect.interest.SiftImageScaleSpace;
import boofcv.struct.feature.SurfFeature;
import boofcv.struct.image.ImageFloat32;

public class DescribePointSift {
    private SiftImageScaleSpace ss;
    private double sigmaToRadius;
    private int gridWidth;
    private int numSamples;
    private int numHistBins;
    private double angleStep;
    private ImageFloat32 image;
    private ImageFloat32 derivX;
    private ImageFloat32 derivY;
    private double[][] histograms;
    private double[] gridWeights;

    public DescribePointSift(int gridWidth, int numSamples, int numHistBins, double weightSigma, double sigmaToRadius) {
        this.gridWidth = gridWidth;
        this.numSamples = numSamples;
        this.numHistBins = numHistBins;
        this.sigmaToRadius = sigmaToRadius;
        this.angleStep = Math.PI * 2 / (double)numHistBins;
        this.histograms = new double[gridWidth * gridWidth][numHistBins];
        int gridSampleLength = numSamples * gridWidth;
        this.gridWeights = new double[gridSampleLength * gridSampleLength];
        weightSigma *= (double)gridSampleLength;
        int index = 0;
        for (int y = -gridSampleLength / 2; y < gridSampleLength / 2; ++y) {
            for (int x = -gridSampleLength / 2; x < gridSampleLength / 2; ++x) {
                double d = Math.sqrt(((double)x + 0.5) * ((double)x + 0.5) + ((double)y + 0.5) * ((double)y + 0.5));
                this.gridWeights[index++] = Math.exp(-0.5 * d * d / (weightSigma * weightSigma));
            }
        }
    }

    public void setScaleSpace(SiftImageScaleSpace ss) {
        this.ss = ss;
    }

    public void process(double c_x, double c_y, double scale, double orientation, SurfFeature desc) {
        int imageIndex = this.ss.scaleToImageIndex(scale);
        double pixelScale = this.ss.imageIndexToPixelScale(imageIndex);
        this.process(c_x, c_y, scale, orientation, imageIndex, pixelScale, desc);
    }

    public void process(double c_x, double c_y, double scale, double orientation, int imageIndex, double pixelScale, SurfFeature desc) {
        int i;
        this.image = this.ss.getPyramidLayer(imageIndex);
        this.derivX = this.ss.getDerivativeX(imageIndex);
        this.derivY = this.ss.getDerivativeY(imageIndex);
        for (i = 0; i < desc.value.length; ++i) {
            desc.value[i] = 0.0;
        }
        for (i = 0; i < this.histograms.length; ++i) {
            for (int j = 0; j < this.histograms[i].length; ++j) {
                this.histograms[i][j] = 0.0;
            }
        }
        this.constructHistograms(c_x / pixelScale, c_y / pixelScale, scale / pixelScale, orientation);
        this.computeDescriptor(desc);
    }

    private void constructHistograms(double c_x, double c_y, double scale, double orientation) {
        double c = Math.cos(orientation);
        double s = Math.sin(orientation);
        int gridRadius = this.gridWidth / 2;
        double sampleUnit = 2.0 * scale * this.sigmaToRadius / (double)this.numSamples;
        double gridCellLength = (double)this.numSamples * sampleUnit;
        int gridCellLengthI = (int)(gridCellLength + 0.5);
        int allSampleIndex = 0;
        for (int gy = 0; gy < this.gridWidth; ++gy) {
            double gridY = (double)(gy - gridRadius) * gridCellLength;
            for (int gx = 0; gx < this.gridWidth; ++gx) {
                double gridX = (double)(gx - gridRadius) * gridCellLength;
                for (int sy = 0; sy < this.numSamples; ++sy) {
                    double y = (double)sy * sampleUnit + gridY;
                    int sx = 0;
                    while (sx < this.numSamples) {
                        double x = (double)sx * sampleUnit + gridX;
                        int px = (int)(x * c - y * s + c_x + 0.5);
                        int py = (int)(x * s + y * c + c_y + 0.5);
                        if (this.image.isInBounds(px, py)) {
                            double dx = this.derivX.unsafe_get(px, py);
                            double dy = this.derivY.unsafe_get(px, py);
                            double w = this.gridWeights[allSampleIndex];
                            double adjX = (dx * c + dy * s) * w;
                            double adjY = (-dx * s + dy * c) * w;
                            this.addToHistograms(gx - gridRadius, gy - gridRadius, x / gridCellLength, y / gridCellLength, adjX, adjY);
                        }
                        ++sx;
                        ++allSampleIndex;
                    }
                }
            }
        }
    }

    private void addToHistograms(int gridX, int gridY, double locX, double locY, double gradX, double gradY) {
        int angleBin = (int)((Math.atan2(gradY, gradX) + Math.PI) / this.angleStep);
        if (angleBin >= this.numHistBins) {
            angleBin = this.numHistBins - 1;
        }
        double gradMag = Math.sqrt(gradX * gradX + gradY * gradY);
        int gridRadius = this.gridWidth / 2;
        int startY = gridY > -gridRadius ? -1 : 0;
        int endY = gridY < gridRadius - 1 ? 1 : 0;
        int startX = gridX > -gridRadius ? -1 : 0;
        int endX = gridX < gridRadius - 1 ? 1 : 0;
        for (int offY = startY; offY <= endY; ++offY) {
            for (int offX = startX; offX <= endX; ++offX) {
                int binIndex = (gridY + gridRadius + offY) * this.gridWidth + gridX + gridRadius + offX;
                if (offX == 0 && offY == 0) {
                    double[] dArray = this.histograms[binIndex];
                    int n = angleBin;
                    dArray[n] = dArray[n] + gradMag;
                    continue;
                }
                double distX = Math.abs(locX - ((double)(gridX + offX) + 0.5));
                double distY = Math.abs(locY - ((double)(gridY + offY) + 0.5));
                if (!(distX < 1.0) || !(distY < 1.0)) continue;
                double w = (1.0 - distX) * (1.0 - distY);
                double[] dArray = this.histograms[binIndex];
                int n = angleBin;
                dArray[n] = dArray[n] + w * gradMag;
            }
        }
    }

    private void computeDescriptor(SurfFeature desc) {
        double v;
        int index = 0;
        int indexGrid = 0;
        double sumSq = 0.0;
        for (int gy = 0; gy < this.gridWidth; ++gy) {
            int gx = 0;
            while (gx < this.gridWidth) {
                for (int hist = 0; hist < this.numHistBins; ++hist) {
                    int n = index++;
                    double d = this.histograms[indexGrid][hist];
                    desc.value[n] = d;
                    v = d;
                    sumSq += v * v;
                }
                ++gx;
                ++indexGrid;
            }
        }
        double norm = Math.sqrt(sumSq);
        int i = 0;
        while (i < desc.size()) {
            int n = i++;
            desc.value[n] = desc.value[n] / norm;
        }
        sumSq = 0.0;
        for (i = 0; i < desc.size(); ++i) {
            v = desc.value[i];
            if (v > 0.2) {
                desc.value[i] = 0.2;
                v = 0.2;
            }
            sumSq += v * v;
        }
        norm = Math.sqrt(sumSq);
        i = 0;
        while (i < desc.size()) {
            int n = i++;
            desc.value[n] = desc.value[n] / norm;
        }
    }

    public int getDescriptorLength() {
        return this.gridWidth * this.gridWidth * this.numHistBins;
    }
}

