/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import java.util.List;

public class WrapFHtoInterestPoint<T extends ImageSingleBand, II extends ImageSingleBand>
implements InterestPointDetector<T> {
    FastHessianFeatureDetector<II> detector;
    List<ScalePoint> location;
    II integral;

    public WrapFHtoInterestPoint(FastHessianFeatureDetector<II> detector) {
        this.detector = detector;
    }

    @Override
    public void detect(T input) {
        if (this.integral != null) {
            this.integral.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        }
        this.integral = GIntegralImageOps.transform(input, this.integral);
        this.detector.detect(this.integral);
        this.location = this.detector.getFoundPoints();
    }

    @Override
    public int getNumberOfFeatures() {
        return this.location.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.location.get(featureIndex);
    }

    @Override
    public double getScale(int featureIndex) {
        return this.location.get((int)featureIndex).scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }
}

