/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.PlanarCalibrationTarget;
import boofcv.alg.geo.h.HomographyLinear4;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class Zhang99ComputeTargetHomography {
    HomographyLinear4 linear = new HomographyLinear4(true);
    DenseMatrix64F found = new DenseMatrix64F(3, 3);
    List<Point2D_F64> worldPoints;

    public Zhang99ComputeTargetHomography(PlanarCalibrationTarget config) {
        this.worldPoints = config.points;
    }

    public boolean computeHomography(List<Point2D_F64> observedPoints) {
        if (observedPoints.size() != this.worldPoints.size()) {
            throw new IllegalArgumentException("Unexpected number of grid points.");
        }
        ArrayList<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
        for (int i = 0; i < observedPoints.size(); ++i) {
            pairs.add(new AssociatedPair(this.worldPoints.get(i), observedPoints.get(i), true));
        }
        return this.linear.process(pairs, this.found);
    }

    public DenseMatrix64F getHomography() {
        return this.found.copy();
    }
}

