/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import java.util.List;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.ReshapeMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;
import org.ejml.ops.SpecializedOps;

public class Zhang99CalibrationMatrixFromHomographies {
    private DenseMatrix64F A = new DenseMatrix64F(1, 1);
    private SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)0, (int)0, (boolean)true, (boolean)true, (boolean)false);
    private DenseMatrix64F b;
    private DenseMatrix64F K = new DenseMatrix64F(3, 3);
    private boolean assumeZeroSkew;

    public Zhang99CalibrationMatrixFromHomographies(boolean assumeZeroSkew) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.b = assumeZeroSkew ? new DenseMatrix64F(5, 1) : new DenseMatrix64F(6, 1);
    }

    public void process(List<DenseMatrix64F> homographies) {
        if (this.assumeZeroSkew) {
            if (homographies.size() < 2) {
                throw new IllegalArgumentException("At least two homographies are required");
            }
        } else if (homographies.size() < 3) {
            throw new IllegalArgumentException("At least three homographies are required");
        }
        if (this.assumeZeroSkew) {
            this.setupA_NoSkew(homographies);
            if (!this.svd.decompose((Matrix64F)this.A)) {
                throw new RuntimeException("SVD failed");
            }
            if (homographies.size() == 2) {
                DenseMatrix64F V = (DenseMatrix64F)this.svd.getV(null, false);
                SpecializedOps.subvector((RowD1Matrix64F)V, (int)0, (int)4, (int)V.numRows, (boolean)false, (int)0, (RowD1Matrix64F)this.b);
            } else {
                SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)this.b);
            }
            this.computeParam_ZeroSkew();
        } else {
            this.setupA(homographies);
            if (!this.svd.decompose((Matrix64F)this.A)) {
                throw new RuntimeException("SVD failed");
            }
            SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)this.b);
            this.computeParam();
        }
    }

    private void setupA(List<DenseMatrix64F> homographies) {
        this.A.reshape(2 * homographies.size(), 6, false);
        DenseMatrix64F h1 = new DenseMatrix64F(3, 1);
        DenseMatrix64F h2 = new DenseMatrix64F(3, 1);
        DenseMatrix64F v12 = new DenseMatrix64F(1, 6);
        DenseMatrix64F v11 = new DenseMatrix64F(1, 6);
        DenseMatrix64F v22 = new DenseMatrix64F(1, 6);
        DenseMatrix64F v11m22 = new DenseMatrix64F(1, 6);
        for (int i = 0; i < homographies.size(); ++i) {
            DenseMatrix64F H = homographies.get(i);
            CommonOps.extract((ReshapeMatrix64F)H, (int)0, (int)3, (int)0, (int)1, (ReshapeMatrix64F)h1, (int)0, (int)0);
            CommonOps.extract((ReshapeMatrix64F)H, (int)0, (int)3, (int)1, (int)2, (ReshapeMatrix64F)h2, (int)0, (int)0);
            double max1 = CommonOps.elementMaxAbs((D1Matrix64F)h1);
            double max2 = CommonOps.elementMaxAbs((D1Matrix64F)h2);
            double max = Math.max(max1, max2);
            CommonOps.divide((double)max, (D1Matrix64F)h1);
            CommonOps.divide((double)max, (D1Matrix64F)h2);
            this.computeV(h1, h2, v12);
            this.computeV(h1, h1, v11);
            this.computeV(h2, h2, v22);
            CommonOps.sub((D1Matrix64F)v11, (D1Matrix64F)v22, (D1Matrix64F)v11m22);
            CommonOps.insert((ReshapeMatrix64F)v12, (ReshapeMatrix64F)this.A, (int)(i * 2), (int)0);
            CommonOps.insert((ReshapeMatrix64F)v11m22, (ReshapeMatrix64F)this.A, (int)(i * 2 + 1), (int)0);
        }
    }

    private void setupA_NoSkew(List<DenseMatrix64F> homographies) {
        this.A.reshape(2 * homographies.size(), 5, false);
        DenseMatrix64F h1 = new DenseMatrix64F(3, 1);
        DenseMatrix64F h2 = new DenseMatrix64F(3, 1);
        DenseMatrix64F v12 = new DenseMatrix64F(1, 5);
        DenseMatrix64F v11 = new DenseMatrix64F(1, 5);
        DenseMatrix64F v22 = new DenseMatrix64F(1, 5);
        DenseMatrix64F v11m22 = new DenseMatrix64F(1, 5);
        for (int i = 0; i < homographies.size(); ++i) {
            DenseMatrix64F H = homographies.get(i);
            CommonOps.extract((ReshapeMatrix64F)H, (int)0, (int)3, (int)0, (int)1, (ReshapeMatrix64F)h1, (int)0, (int)0);
            CommonOps.extract((ReshapeMatrix64F)H, (int)0, (int)3, (int)1, (int)2, (ReshapeMatrix64F)h2, (int)0, (int)0);
            double max1 = CommonOps.elementMaxAbs((D1Matrix64F)h1);
            double max2 = CommonOps.elementMaxAbs((D1Matrix64F)h2);
            double max = Math.max(max1, max2);
            CommonOps.divide((double)max, (D1Matrix64F)h1);
            CommonOps.divide((double)max, (D1Matrix64F)h2);
            this.computeV_NoSkew(h1, h2, v12);
            this.computeV_NoSkew(h1, h1, v11);
            this.computeV_NoSkew(h2, h2, v22);
            CommonOps.sub((D1Matrix64F)v11, (D1Matrix64F)v22, (D1Matrix64F)v11m22);
            CommonOps.insert((ReshapeMatrix64F)v12, (ReshapeMatrix64F)this.A, (int)(i * 2), (int)0);
            CommonOps.insert((ReshapeMatrix64F)v11m22, (ReshapeMatrix64F)this.A, (int)(i * 2 + 1), (int)0);
        }
    }

    private void computeV(DenseMatrix64F h1, DenseMatrix64F h2, DenseMatrix64F v) {
        double h1x = h1.get(0, 0);
        double h1y = h1.get(1, 0);
        double h1z = h1.get(2, 0);
        double h2x = h2.get(0, 0);
        double h2y = h2.get(1, 0);
        double h2z = h2.get(2, 0);
        v.set(0, 0, h1x * h2x);
        v.set(0, 1, h1x * h2y + h1y * h2x);
        v.set(0, 2, h1y * h2y);
        v.set(0, 3, h1z * h2x + h1x * h2z);
        v.set(0, 4, h1z * h2y + h1y * h2z);
        v.set(0, 5, h1z * h2z);
    }

    private void computeV_NoSkew(DenseMatrix64F h1, DenseMatrix64F h2, DenseMatrix64F v) {
        double h1x = h1.get(0, 0);
        double h1y = h1.get(1, 0);
        double h1z = h1.get(2, 0);
        double h2x = h2.get(0, 0);
        double h2y = h2.get(1, 0);
        double h2z = h2.get(2, 0);
        v.set(0, 0, h1x * h2x);
        v.set(0, 1, h1y * h2y);
        v.set(0, 2, h1z * h2x + h1x * h2z);
        v.set(0, 3, h1z * h2y + h1y * h2z);
        v.set(0, 4, h1z * h2z);
    }

    private void computeParam() {
        CommonOps.divide((double)CommonOps.elementMaxAbs((D1Matrix64F)this.b), (D1Matrix64F)this.b);
        double B11 = this.b.get(0, 0);
        double B12 = this.b.get(1, 0);
        double B22 = this.b.get(2, 0);
        double B13 = this.b.get(3, 0);
        double B23 = this.b.get(4, 0);
        double B33 = this.b.get(5, 0);
        double temp0 = B12 * B13 - B11 * B23;
        double temp1 = B11 * B22 - B12 * B12;
        double v0 = temp0 / temp1;
        double lambda = B33 - (B13 * B13 + v0 * temp0) / B11;
        double a = Math.sqrt(Math.abs(lambda / B11));
        double b = Math.sqrt(Math.abs(lambda * B11 / temp1));
        double c = -B12 * b / B11;
        double u0 = c * v0 / a - B13 / B11;
        this.K.set(0, 0, a);
        this.K.set(0, 1, c);
        this.K.set(0, 2, u0);
        this.K.set(1, 1, b);
        this.K.set(1, 2, v0);
        this.K.set(2, 2, 1.0);
    }

    private void computeParam_ZeroSkew() {
        CommonOps.divide((double)CommonOps.elementMaxAbs((D1Matrix64F)this.b), (D1Matrix64F)this.b);
        double B11 = this.b.get(0, 0);
        double B22 = this.b.get(1, 0);
        double B13 = this.b.get(2, 0);
        double B23 = this.b.get(3, 0);
        double B33 = this.b.get(4, 0);
        double temp0 = -B11 * B23;
        double temp1 = B11 * B22;
        double v0 = temp0 / temp1;
        double lambda = B33 - (B13 * B13 + v0 * temp0) / B11;
        double a = Math.sqrt(Math.abs(lambda / B11));
        double b = Math.sqrt(Math.abs(lambda * B11 / temp1));
        double u0 = -B13 / B11;
        this.K.set(0, 0, a);
        this.K.set(0, 1, 0.0);
        this.K.set(0, 2, u0);
        this.K.set(1, 1, b);
        this.K.set(1, 2, v0);
        this.K.set(2, 2, 1.0);
    }

    public DenseMatrix64F getCalibrationMatrix() {
        return this.K;
    }
}

