/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.PlanarCalibrationTarget;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolver;
import org.ejml.factory.LinearSolverFactory;

public class RadialDistortionEstimateLinear {
    private DenseMatrix64F A = new DenseMatrix64F(1, 1);
    private DenseMatrix64F B = new DenseMatrix64F(1, 1);
    private DenseMatrix64F X;
    private LinearSolver<DenseMatrix64F> solver = LinearSolverFactory.leastSquares((int)0, (int)0);
    private List<Point2D_F64> worldPoints;

    public RadialDistortionEstimateLinear(PlanarCalibrationTarget gridDesc, int numParam) {
        this.worldPoints = gridDesc.points;
        this.X = new DenseMatrix64F(numParam, 1);
    }

    public void process(DenseMatrix64F cameraCalibration, List<DenseMatrix64F> homographies, List<List<Point2D_F64>> observations) {
        this.init(observations.size());
        this.setupA_and_B(cameraCalibration, homographies, observations);
        if (!this.solver.setA((Matrix64F)this.A)) {
            throw new RuntimeException("Solver had problems");
        }
        this.solver.solve((Matrix64F)this.B, (Matrix64F)this.X);
    }

    private void init(int numGridObservations) {
        this.A.reshape(2 * numGridObservations * this.worldPoints.size(), this.X.numRows, false);
        this.B.reshape(this.A.numRows, 1, false);
    }

    private void setupA_and_B(DenseMatrix64F K, List<DenseMatrix64F> homographies, List<List<Point2D_F64>> observations) {
        int N = observations.size();
        double u0 = K.get(0, 2);
        double v0 = K.get(1, 2);
        Point2D_F64 projCalibrated = new Point2D_F64();
        Point2D_F64 projPixel = new Point2D_F64();
        int pointIndex = 0;
        for (int indexObs = 0; indexObs < N; ++indexObs) {
            DenseMatrix64F H = homographies.get(indexObs);
            List<Point2D_F64> obs = observations.get(indexObs);
            for (int gridIndex = 0; gridIndex < this.worldPoints.size(); ++gridIndex) {
                Point2D_F64 gridPt = this.worldPoints.get(gridIndex);
                GeometryMath_F64.mult((DenseMatrix64F)H, (GeoTuple2D_F64)gridPt, (GeoTuple2D_F64)projCalibrated);
                GeometryMath_F64.mult((DenseMatrix64F)K, (GeoTuple2D_F64)projCalibrated, (GeoTuple2D_F64)projPixel);
                double r2 = projCalibrated.x * projCalibrated.x + projCalibrated.y * projCalibrated.y;
                double a = 1.0;
                for (int i = 0; i < this.X.numRows; ++i) {
                    this.A.set(pointIndex * 2 + 0, i, (projPixel.x - u0) * (a *= r2));
                    this.A.set(pointIndex * 2 + 1, i, (projPixel.y - v0) * a);
                }
                Point2D_F64 obsPixel = obs.get(gridIndex);
                this.B.set(pointIndex * 2 + 0, 0, obsPixel.x - projPixel.x);
                this.B.set(pointIndex * 2 + 1, 0, obsPixel.y - projPixel.y);
                ++pointIndex;
            }
        }
    }

    public double[] getParameters() {
        return this.X.data;
    }
}

