/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.alg.feature.detect.InvalidCalibrationTarget;
import boofcv.alg.feature.detect.grid.ConnectGridSquares;
import boofcv.alg.feature.detect.quadblob.DetectQuadBlobsBinary;
import boofcv.alg.feature.detect.quadblob.OrderPointsIntoGrid;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.combinatorics.Combinations;

public class DetectSquareCalibrationPoints {
    private ImageUInt8 binaryA = new ImageUInt8(1, 1);
    private ImageUInt8 binaryB = new ImageUInt8(1, 1);
    DetectQuadBlobsBinary detectBlobs;
    private List<QuadBlob> squares;
    private int numSquares;
    private int maxCombinations;
    private double relativeSizeThreshold;
    private String errorMessage;
    OrderPointsIntoGrid orderAlg = new OrderPointsIntoGrid();
    List<Point2D_F64> interestPoints;
    private List<QuadBlob> interestSquares;

    public DetectSquareCalibrationPoints(int maxCombinations, double relativeSizeThreshold, int gridCols, int gridRows) {
        if (gridCols <= 0 || gridRows <= 0) {
            throw new IllegalArgumentException("Columns and rows must be more than zero");
        }
        if (gridCols % 2 == 0 || gridRows % 2 == 0) {
            throw new IllegalArgumentException("Number of columns and rows must be odd");
        }
        this.numSquares = (gridCols / 2 + 1) * (gridRows / 2 + 1);
        this.maxCombinations = maxCombinations;
        this.relativeSizeThreshold = relativeSizeThreshold;
        this.detectBlobs = new DetectQuadBlobsBinary(0, 0.25, this.numSquares);
    }

    public boolean process(ImageUInt8 thresholded) {
        this.interestPoints = new ArrayList<Point2D_F64>();
        this.interestSquares = new ArrayList<QuadBlob>();
        int contourSize = (int)(this.relativeSizeThreshold * 80.0 / 640.0 * (double)thresholded.width);
        this.detectBlobs.setMinContourSize(contourSize);
        this.binaryA.reshape(thresholded.width, thresholded.height);
        this.binaryB.reshape(thresholded.width, thresholded.height);
        BinaryImageOps.erode8((ImageUInt8)thresholded, (ImageUInt8)this.binaryA);
        BinaryImageOps.erode8((ImageUInt8)this.binaryA, (ImageUInt8)this.binaryB);
        BinaryImageOps.dilate8((ImageUInt8)this.binaryB, (ImageUInt8)this.binaryA);
        BinaryImageOps.dilate8((ImageUInt8)this.binaryA, (ImageUInt8)this.binaryB);
        if (!this.detectBlobs.process(this.binaryB)) {
            return this.fail(this.detectBlobs.getMessage());
        }
        this.squares = this.detectBlobs.getDetected();
        ConnectGridSquares.connect(this.squares);
        List<QuadBlob> squaresPruned = ConnectGridSquares.pruneSmallIslands(this.squares);
        return this.shuffleToFindTarget(squaresPruned);
    }

    private boolean shuffleToFindTarget(List<QuadBlob> squares) {
        if (squares.size() < this.numSquares) {
            return this.fail("Not enough blobs detected");
        }
        Combinations combinations = new Combinations(squares, this.numSquares);
        if (combinations.computeTotalCombinations() > (long)this.maxCombinations) {
            return this.fail("Too many possible combinations");
        }
        ArrayList<QuadBlob> list = new ArrayList<QuadBlob>();
        while (true) {
            combinations.getBucket(list);
            try {
                this.interestPoints = new ArrayList<Point2D_F64>();
                for (QuadBlob b : list) {
                    for (Point2D_I32 c : b.corners) {
                        this.interestPoints.add(new Point2D_F64((double)c.x, (double)c.y));
                    }
                }
                this.interestSquares = list;
                this.orderAlg.process(this.interestPoints);
                this.interestPoints = this.orderAlg.getOrdered();
                return true;
            }
            catch (InvalidCalibrationTarget invalidTarget) {
                if (combinations.next()) continue;
                return this.fail("No target found after shuffling");
            }
            break;
        }
    }

    public List<Point2D_F64> getTargetQuadrilateral() {
        return this.orderAlg.getQuadrilateral();
    }

    private boolean fail(String message) {
        this.errorMessage = message;
        return false;
    }

    public ImageSInt32 getBlobs() {
        return this.detectBlobs.getLabeledImage();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<QuadBlob> getAllSquares() {
        return this.squares;
    }

    public List<QuadBlob> getInterestSquares() {
        return this.interestSquares;
    }

    public List<Point2D_F64> getInterestPoints() {
        return this.interestPoints;
    }

    public List<QuadBlob> getSquaresBad() {
        return this.detectBlobs.getInvalid();
    }

    public int getNumberOfLabels() {
        return this.detectBlobs.getNumLabels();
    }

    public DetectQuadBlobsBinary getDetectBlobs() {
        return this.detectBlobs;
    }
}

