/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.peak.SearchLocalPeak;
import boofcv.alg.feature.detect.chess.DetectChessSquaresBinary;
import boofcv.alg.feature.detect.chess.OrderChessboardQuadBlobs;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPoint;
import boofcv.factory.feature.detect.peak.FactorySearchLocalPeak;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.sorting.QuickSort_S32;
import org.ddogleg.struct.FastQueue;

public class DetectChessCalibrationPoints<T extends ImageSingleBand, D extends ImageSingleBand> {
    private D derivX;
    private D derivY;
    private int radius;
    private DetectChessSquaresBinary findBound;
    private ImageUInt8 binary = new ImageUInt8(1, 1);
    private ImageUInt8 eroded = new ImageUInt8(1, 1);
    private double userBinaryThreshold = -1.0;
    private int userAdaptiveRadius = 20;
    private double userAdaptiveBias = -10.0;
    private GeneralFeatureIntensity<T, D> intensityAlg;
    private List<Point2D_F64> subpixel;
    private ImageRectangle targetRect;
    private OrderChessboardQuadBlobs orderAlg;
    private boolean foundBound;
    private SearchLocalPeak<ImageFloat32> localPeak = FactorySearchLocalPeak.meanShiftUniform((int)10, (float)1.0E-4f, ImageFloat32.class);
    private T work1;
    private T work2;
    private int[] indexes = new int[4];
    private int[] values = new int[4];
    private QuickSort_S32 sorter = new QuickSort_S32();
    FastQueue<Point2D_F32> corners = new FastQueue(Point2D_F32.class, true);

    public DetectChessCalibrationPoints(int numCols, int numRows, int radius, double relativeSizeThreshold, Class<T> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        this.radius = radius;
        this.orderAlg = new OrderChessboardQuadBlobs(numCols, numRows);
        this.work1 = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
        this.work2 = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
        this.derivX = GeneralizedImageOps.createSingleBand((Class)derivType, (int)1, (int)1);
        this.derivY = GeneralizedImageOps.createSingleBand((Class)derivType, (int)1, (int)1);
        this.intensityAlg = FactoryIntensityPoint.shiTomasi((int)radius, (boolean)true, (Class)derivType);
        this.findBound = new DetectChessSquaresBinary(numCols, numRows, 10);
        this.localPeak.setSearchRadius(2);
        this.reset();
    }

    public void reset() {
    }

    public boolean process(T gray) {
        this.targetRect = null;
        this.subpixel = new ArrayList<Point2D_F64>();
        this.binary.reshape(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        this.eroded.reshape(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        this.adjustForImageSize(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        this.foundBound = this.detectChessBoard(gray);
        if (!this.foundBound) {
            return false;
        }
        this.targetRect = this.findBound.getBoundRect();
        ImageSingleBand subGray = gray.subimage(this.targetRect.x0, this.targetRect.y0, this.targetRect.x1, this.targetRect.y1, null);
        this.derivX.reshape(subGray.width, subGray.height);
        this.derivY.reshape(subGray.width, subGray.height);
        GImageDerivativeOps.sobel((ImageSingleBand)subGray, this.derivX, this.derivY, (BorderType)BorderType.EXTENDED);
        this.intensityAlg.process(subGray, this.derivX, this.derivY, null, null, null);
        List<QuadBlob> unorderedBlobs = this.findBound.getGraphBlobs();
        if (!this.orderAlg.order(unorderedBlobs)) {
            return false;
        }
        this.seedPointsFromQuadCorner(this.orderAlg.getResults());
        this.meanShiftBlobCorners(this.intensityAlg.getIntensity(), this.targetRect);
        ArrayList<Point2D_F64> points = new ArrayList<Point2D_F64>();
        for (int i = 0; i < this.corners.size(); ++i) {
            Point2D_F32 c = (Point2D_F32)this.corners.get(i);
            points.add(new Point2D_F64((double)c.x, (double)c.y));
        }
        int dist = (int)(((Point2D_F64)points.get(0)).distance((GeoTuple2D_F64)points.get(1)) + 1.0);
        for (Point2D_F64 p : points) {
            this.subpixel.add(this.refineSubpixel(p, dist, this.targetRect.x0, this.targetRect.y0, this.intensityAlg.getIntensity()));
        }
        return this.subpixel != null;
    }

    private void adjustForImageSize(int imgWidth, int imgHeight) {
    }

    private boolean detectChessBoard(T gray) {
        if (this.userBinaryThreshold <= 0.0) {
            this.work1.reshape(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
            this.work2.reshape(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
            GThresholdImageOps.adaptiveSquare(gray, (ImageUInt8)this.binary, (int)this.userAdaptiveRadius, (double)this.userAdaptiveBias, (boolean)true, this.work1, this.work2);
        } else {
            GThresholdImageOps.threshold(gray, (ImageUInt8)this.binary, (double)this.userBinaryThreshold, (boolean)true);
        }
        BinaryImageOps.erode8((ImageUInt8)this.binary, (ImageUInt8)this.eroded);
        return this.findBound.process(this.eroded);
    }

    private Point2D_F64 refineSubpixel(Point2D_F64 pt, int dist, int x0, int y0, ImageFloat32 intensity) {
        int r = Math.min(dist / 4, this.radius + 3);
        if (r < 1) {
            r = 1;
        }
        ImageRectangle area = new ImageRectangle((int)(pt.x - (double)r - (double)x0), (int)(pt.y - (double)r - (double)y0), (int)(pt.x + (double)r - (double)x0 + 1.0), (int)(pt.y + (double)r + 1.0 - (double)y0));
        BoofMiscOps.boundRectangleInside((ImageBase)intensity, (ImageRectangle)area);
        float meanX = 0.0f;
        float meanY = 0.0f;
        float sum = 0.0f;
        for (int i = area.y0; i < area.y1; ++i) {
            for (int j = area.x0; j < area.x1; ++j) {
                float value = intensity.get(j, i);
                meanX += (float)j * value;
                meanY += (float)i * value;
                sum += value;
            }
        }
        return new Point2D_F64((double)((float)x0 + (meanX /= sum)), (double)((float)y0 + (meanY /= sum)));
    }

    private void seedPointsFromQuadCorner(List<QuadBlob> blobs) {
        this.corners.reset();
        for (int i = 0; i < blobs.size(); ++i) {
            blobs.get((int)i).index = i;
        }
        boolean[] marked = new boolean[blobs.size()];
        for (int i = 0; i < blobs.size(); ++i) {
            int j;
            QuadBlob b = blobs.get(i);
            marked[i] = true;
            int N = b.conn.size();
            for (j = 0; j < N; ++j) {
                this.values[j] = b.conn.get((int)j).index;
            }
            this.sorter.sort(this.values, N, this.indexes);
            for (j = 0; j < N; ++j) {
                int next = this.indexes[j];
                if (marked[b.conn.get((int)next).index]) continue;
                QuadBlob c = b.conn.get(next);
                Point2D_I32 c0 = b.corners.get(b.connIndex.data[next]);
                int indexOfB = c.conn.indexOf(b);
                Point2D_I32 c1 = c.corners.get(c.connIndex.data[indexOfB]);
                int x = (c0.x + c1.x) / 2;
                int y = (c0.y + c1.y) / 2;
                ((Point2D_F32)this.corners.grow()).set((float)x, (float)y);
            }
        }
    }

    private void meanShiftBlobCorners(ImageFloat32 intensity, ImageRectangle rect) {
        this.localPeak.setImage((ImageSingleBand)intensity);
        for (int i = 0; i < this.corners.size(); ++i) {
            Point2D_F32 c = (Point2D_F32)this.corners.get(i);
            this.localPeak.search(c.x - (float)rect.x0, c.y - (float)rect.y0);
            c.x = this.localPeak.getPeakX() + (float)rect.x0;
            c.y = this.localPeak.getPeakY() + (float)rect.y0;
        }
    }

    public void renderIntensity(ImageFloat32 wholeImage) {
        if (this.targetRect == null) {
            ImageMiscOps.fill((ImageFloat32)wholeImage, (float)0.0f);
        } else {
            ImageFloat32 found = this.intensityAlg.getIntensity();
            ImageFloat32 out = (ImageFloat32)wholeImage.subimage(this.targetRect.x0, this.targetRect.y0, this.targetRect.x1, this.targetRect.y1, null);
            out.setTo((ImageSingleBand)found);
        }
    }

    public OrderChessboardQuadBlobs getOrderAlg() {
        return this.orderAlg;
    }

    public DetectChessSquaresBinary getFindBound() {
        return this.findBound;
    }

    public List<Point2D_F64> getPoints() {
        return this.subpixel;
    }

    public ImageUInt8 getBinary() {
        return this.eroded;
    }

    public void setUserBinaryThreshold(double userBinaryThreshold) {
        this.userBinaryThreshold = userBinaryThreshold;
    }

    public double getUserBinaryThreshold() {
        return this.userBinaryThreshold;
    }

    public int getUserAdaptiveRadius() {
        return this.userAdaptiveRadius;
    }

    public void setUserAdaptiveRadius(int userAdaptiveRadius) {
        this.userAdaptiveRadius = userAdaptiveRadius;
    }

    public double getUserAdaptiveBias() {
        return this.userAdaptiveBias;
    }

    public void setUserAdaptiveBias(double userAdaptiveBias) {
        this.userAdaptiveBias = userAdaptiveBias;
    }

    public boolean isFoundBound() {
        return this.foundBound;
    }
}

