/*
 * Decompiled with CFR 0.152.
 */
package org.openkinect.freenect.util;

import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openkinect.freenect.Device;
import org.openkinect.freenect.LogHandler;
import org.openkinect.freenect.LogLevel;

public class Jdk14LogHandler
implements LogHandler {
    private final Logger logger = Logger.getLogger("freenect");
    private final EnumMap<LogLevel, Level> levelMap = new EnumMap(LogLevel.class);

    public Jdk14LogHandler() {
        this.logger.setLevel(Level.ALL);
        this.levelMap.put(LogLevel.FATAL, Level.SEVERE);
        this.levelMap.put(LogLevel.ERROR, Level.SEVERE);
        this.levelMap.put(LogLevel.WARNING, Level.WARNING);
        this.levelMap.put(LogLevel.NOTICE, Level.CONFIG);
        this.levelMap.put(LogLevel.INFO, Level.INFO);
        this.levelMap.put(LogLevel.DEBUG, Level.FINE);
        this.levelMap.put(LogLevel.SPEW, Level.FINER);
        this.levelMap.put(LogLevel.FLOOD, Level.FINEST);
    }

    @Override
    public void onMessage(Device dev, LogLevel level, String msg) {
        this.logger.log(this.levelMap.get((Object)level), "device " + dev.getDeviceIndex() + ": " + msg);
    }
}

