/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigGenerator;
import boofcv.struct.ConfigGeneratorPatternSearchBase;
import boofcv.struct.Configuration;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.Tuple2;

public class ConfigGeneratorVector<Config extends Configuration>
extends ConfigGeneratorPatternSearchBase<Config> {
    public ConfigGeneratorVector(long seed, Class<Config> type) {
        super(seed, type);
    }

    @Override
    public String toStringSettings() {
        Object ret = "Vector:\n";
        ret = (String)ret + "discretization," + this.rangeDiscretization + "\n";
        ret = (String)ret + super.toStringSettings();
        ret = (String)ret + "rules:\n";
        for (String key : this.pathToRule.keySet()) {
            ret = (String)ret + key + "," + this.pathToRule.get(key) + "\n";
        }
        return ret;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.configurationWork = BoofMiscOps.copyConfig((Configuration)this.configurationBase);
        this.numTrials = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.numTrials += this.getNumberOfStates((ConfigGenerator.Parameter)this.parameters.get(i));
            if (this.numTrials >= 0) continue;
            throw new IllegalArgumentException("Too many possible states in the vector search. Exceeded size of an int. Try random sampling instead?");
        }
    }

    @Override
    public Config next() {
        this.configCurrent = BoofMiscOps.copyConfig((Configuration)this.configurationWork);
        try {
            int firstTrialInParameter = 0;
            for (int paramIdx = 0; paramIdx < this.parameters.size(); ++paramIdx) {
                ConfigGenerator.Parameter p = (ConfigGenerator.Parameter)this.parameters.get(paramIdx);
                int numStates = this.getNumberOfStates(p);
                if (firstTrialInParameter + numStates > this.trial) {
                    int state = this.trial - firstTrialInParameter;
                    double fraction = numStates == 1 ? 0.0 : (double)state / (double)(numStates - 1);
                    ConfigGeneratorVector.assignValue(this.configCurrent, p.getPath(), p.selectValue(fraction));
                    break;
                }
                firstTrialInParameter += numStates;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ++this.trial;
        return (Config)this.configCurrent;
    }

    public List<Tuple2<String, Integer>> getParameterCounts() {
        ArrayList<Tuple2<String, Integer>> list = new ArrayList<Tuple2<String, Integer>>();
        for (int paramIdx = 0; paramIdx < this.parameters.size(); ++paramIdx) {
            ConfigGenerator.Parameter p = (ConfigGenerator.Parameter)this.parameters.get(paramIdx);
            list.add((Tuple2<String, Integer>)new Tuple2((Object)p.path, (Object)this.getNumberOfStates(p)));
        }
        return list;
    }
}

