/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android.camera;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import boofcv.android.camera.VideoRenderProcessing;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray_I8;

public abstract class VideoImageProcessing<T extends ImageBase<T>>
extends VideoRenderProcessing<T> {
    private Bitmap output;
    private Bitmap outputGUI;
    private final DogArray_I8 storage = new DogArray_I8();

    protected VideoImageProcessing(ImageType<T> imageType) {
        super(imageType);
    }

    @Override
    protected void declareImages(int width, int height) {
        super.declareImages(width, height);
        this.output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.outputGUI = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(T gray) {
        this.process(gray, this.output, this.storage);
        Object object = this.lockGui;
        synchronized (object) {
            Bitmap tmp = this.output;
            this.output = this.outputGUI;
            this.outputGUI = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void render(Canvas canvas, double imageToOutput) {
        Object object = this.lockGui;
        synchronized (object) {
            canvas.drawBitmap(this.outputGUI, 0.0f, 0.0f, null);
        }
    }

    protected abstract void process(T var1, Bitmap var2, DogArray_I8 var3);
}

