/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android;

import android.graphics.Bitmap;
import boofcv.alg.color.ColorFormat;
import boofcv.android.BOverrideConvertAndroid;
import boofcv.android.ImplConvertBitmap;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.ddogleg.struct.DogArray_I8;
import org.jetbrains.annotations.Nullable;

public class ConvertBitmap {
    public static Bitmap checkDeclare(ImageBase input, @Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return Bitmap.createBitmap((int)input.width, (int)input.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (input.width != bitmap.getWidth() || input.height != bitmap.getHeight()) {
            return Bitmap.createBitmap((int)input.width, (int)input.height, (Bitmap.Config)bitmap.getConfig());
        }
        return bitmap;
    }

    public static DogArray_I8 resizeStorage(Bitmap input, @Nullable DogArray_I8 storage) {
        int byteCount = input.getConfig() == Bitmap.Config.ARGB_8888 ? 4 : 2;
        int length = input.getWidth() * input.getHeight() * byteCount;
        if (storage == null) {
            return new DogArray_I8(length);
        }
        storage.resize(length);
        return storage;
    }

    public static <T extends ImageBase<T>> void bitmapToBoof(Bitmap input, T output, @Nullable DogArray_I8 storage) {
        storage = ConvertBitmap.resizeStorage(input, storage);
        if (BOverrideConvertAndroid.invokeBitmapToBoof(input, output, storage.data)) {
            return;
        }
        switch (output.getImageType().getFamily()) {
            case GRAY: {
                if (output.getClass() == GrayF32.class) {
                    ConvertBitmap.bitmapToGray(input, (GrayF32)output, storage);
                    break;
                }
                if (output.getClass() == GrayU8.class) {
                    ConvertBitmap.bitmapToGray(input, (GrayU8)output, storage);
                    break;
                }
                throw new IllegalArgumentException("Unsupported BoofCV Image Type");
            }
            case PLANAR: {
                Planar pl = (Planar)output;
                ConvertBitmap.bitmapToPlanar(input, pl, pl.getBandType(), storage);
                break;
            }
            case INTERLEAVED: {
                if (output.getClass() == InterleavedU8.class) {
                    ConvertBitmap.bitmapToInterleaved(input, (InterleavedU8)output, storage);
                    break;
                }
                if (output.getClass() == InterleavedF32.class) {
                    ConvertBitmap.bitmapToInterleaved(input, (InterleavedF32)output, storage);
                    break;
                }
                throw new IllegalArgumentException("Unsupported BoofCV Image Type");
            }
            default: {
                throw new IllegalArgumentException("Unsupported BoofCV Image Type");
            }
        }
    }

    public static <T extends ImageGray<T>> T bitmapToGray(Bitmap input, T output, Class<T> imageType, @Nullable DogArray_I8 storage) {
        storage = ConvertBitmap.resizeStorage(input, storage);
        if (imageType == GrayF32.class) {
            return (T)ConvertBitmap.bitmapToGray(input, (GrayF32)output, storage);
        }
        if (imageType == GrayU8.class) {
            return (T)ConvertBitmap.bitmapToGray(input, (GrayU8)output, storage);
        }
        throw new IllegalArgumentException("Unsupported BoofCV Image Type");
    }

    public static GrayU8 bitmapToGray(Bitmap input, GrayU8 output, @Nullable DogArray_I8 storage) {
        storage = ConvertBitmap.resizeStorage(input, storage);
        if (output == null) {
            output = new GrayU8(input.getWidth(), input.getHeight());
        } else {
            output.reshape(input.getWidth(), input.getHeight());
        }
        input.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(storage.data));
        ImplConvertBitmap.arrayToGray(storage.data, input.getConfig(), output);
        return output;
    }

    public static GrayF32 bitmapToGray(Bitmap input, GrayF32 output, @Nullable DogArray_I8 storage) {
        if (output == null) {
            output = new GrayF32(input.getWidth(), input.getHeight());
        } else {
            output.reshape(input.getWidth(), input.getHeight());
        }
        storage = ConvertBitmap.resizeStorage(input, storage);
        input.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(storage.data));
        ImplConvertBitmap.arrayToGray(storage.data, input.getConfig(), output);
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> bitmapToPlanar(Bitmap input, Planar<T> output, Class<T> type, @Nullable DogArray_I8 storage) {
        if (output == null) {
            output = new Planar(type, input.getWidth(), input.getHeight(), 3);
        } else {
            int numBands = Math.min(4, Math.max(3, output.getNumBands()));
            output.reshape(input.getWidth(), input.getHeight(), numBands);
        }
        storage = ConvertBitmap.resizeStorage(input, storage);
        input.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(storage.data));
        if (type == GrayU8.class) {
            ImplConvertBitmap.arrayToPlanar_U8(storage.data, input.getConfig(), (Planar<GrayU8>)output);
        } else if (type == GrayF32.class) {
            ImplConvertBitmap.arrayToPlanar_F32(storage.data, input.getConfig(), (Planar<GrayF32>)output);
        } else {
            throw new IllegalArgumentException("Unsupported BoofCV Type");
        }
        return output;
    }

    public static InterleavedU8 bitmapToInterleaved(Bitmap input, InterleavedU8 output, @Nullable DogArray_I8 storage) {
        if (output == null) {
            output = new InterleavedU8(input.getWidth(), input.getHeight(), 3);
        } else if (output.getNumBands() < 3 || output.getNumBands() > 4) {
            output.reshape(input.getWidth(), input.getHeight(), 3);
        } else {
            output.reshape(input.getWidth(), input.getHeight());
        }
        storage = ConvertBitmap.resizeStorage(input, storage);
        input.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(storage.data));
        ImplConvertBitmap.arrayToInterleaved_U8(storage.data, input.getConfig(), output);
        return output;
    }

    public static InterleavedF32 bitmapToInterleaved(Bitmap input, InterleavedF32 output, @Nullable DogArray_I8 storage) {
        if (output == null) {
            output = new InterleavedF32(input.getWidth(), input.getHeight(), 3);
        } else if (output.getNumBands() < 3 || output.getNumBands() > 4) {
            output.reshape(input.getWidth(), input.getHeight(), 3);
        } else {
            output.reshape(input.getWidth(), input.getHeight());
        }
        storage = ConvertBitmap.resizeStorage(input, storage);
        input.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(storage.data));
        ImplConvertBitmap.arrayToInterleaved_F32(storage.data, input.getConfig(), output);
        return output;
    }

    public static void boofToBitmap(ImageBase input, Bitmap output, @Nullable DogArray_I8 storage) {
        storage = ConvertBitmap.resizeStorage(output, storage);
        if (BOverrideConvertAndroid.invokeBoofToBitmap(ColorFormat.RGB, input, output, storage.data)) {
            return;
        }
        if (input instanceof Planar) {
            ConvertBitmap.planarToBitmap((Planar)input, output, storage);
        } else if (input instanceof ImageGray) {
            ConvertBitmap.grayToBitmap((ImageGray)input, output, storage);
        } else if (input instanceof ImageInterleaved) {
            ConvertBitmap.interleavedToBitmap((ImageInterleaved)input, output, storage);
        } else {
            throw new IllegalArgumentException("Unsupported input image type");
        }
    }

    public static void boofToBitmap(ColorFormat color, ImageBase input, Bitmap output, @Nullable DogArray_I8 storage) {
        storage = ConvertBitmap.resizeStorage(output, storage);
        if (BOverrideConvertAndroid.invokeBoofToBitmap(color, input, output, storage.data)) {
            return;
        }
        if (input instanceof ImageGray) {
            ConvertBitmap.grayToBitmap((ImageGray)input, output, storage);
            return;
        }
        switch (color) {
            case RGB: {
                ConvertBitmap.boofToBitmap(input, output, storage);
                return;
            }
            case YUV: {
                if (!(input instanceof ImageInterleaved)) break;
                ConvertBitmap.interleavedYuvToBitmap((ImageInterleaved)input, output, storage);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported input image type");
    }

    public static void grayToBitmap(ImageGray input, Bitmap output, @Nullable DogArray_I8 storage) {
        if (input instanceof GrayU8) {
            ConvertBitmap.grayToBitmap((GrayU8)input, output, storage);
        } else if (input instanceof GrayF32) {
            ConvertBitmap.grayToBitmap((GrayF32)input, output, storage);
        } else {
            throw new IllegalArgumentException("Unsupported BoofCV Type: " + input);
        }
    }

    public static void grayToBitmap(GrayU8 input, Bitmap output, @Nullable DogArray_I8 storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        storage = ConvertBitmap.resizeStorage(output, storage);
        ImplConvertBitmap.grayToArray(input, storage.data, output.getConfig());
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage.data));
    }

    public static void grayToBitmap(GrayF32 input, Bitmap output, @Nullable DogArray_I8 storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        storage = ConvertBitmap.resizeStorage(output, storage);
        ImplConvertBitmap.grayToArray(input, storage.data, output.getConfig());
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage.data));
    }

    public static <T extends ImageGray<T>> void planarToBitmap(Planar<T> input, Bitmap output, @Nullable DogArray_I8 storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        storage = ConvertBitmap.resizeStorage(output, storage);
        if (input.getBandType() == GrayU8.class) {
            ImplConvertBitmap.planarToArray_U8(input, storage.data, output.getConfig());
        } else if (input.getBandType() == GrayF32.class) {
            ImplConvertBitmap.planarToArray_F32(input, storage.data, output.getConfig());
        } else {
            throw new IllegalArgumentException("Unsupported BoofCV Type");
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage.data));
    }

    public static <T extends ImageInterleaved<T>> void interleavedToBitmap(T input, Bitmap output, @Nullable DogArray_I8 storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        storage = ConvertBitmap.resizeStorage(output, storage);
        if (input.getImageType().getDataType() == ImageDataType.U8) {
            ImplConvertBitmap.interleavedToArray((InterleavedU8)input, storage.data, output.getConfig());
        } else if (input.getImageType().getDataType() == ImageDataType.F32) {
            ImplConvertBitmap.interleavedToArray((InterleavedF32)input, storage.data, output.getConfig());
        } else {
            throw new IllegalArgumentException("Unsupported BoofCV Type");
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage.data));
    }

    public static <T extends ImageInterleaved<T>> void interleavedYuvToBitmap(T input, Bitmap output, @Nullable DogArray_I8 storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        storage = ConvertBitmap.resizeStorage(output, storage);
        if (input.getImageType().getDataType() == ImageDataType.U8) {
            switch (output.getConfig()) {
                case ARGB_8888: {
                    ImplConvertBitmap.interleavedYuvToArgb8888((InterleavedU8)input, storage.data);
                    output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage.data));
                    return;
                }
                case RGB_565: {
                    ImplConvertBitmap.interleavedYuvToRGB565((InterleavedU8)input, storage.data);
                    output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage.data));
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported BoofCV Type");
    }

    public static Bitmap grayToBitmap(GrayU8 input, Bitmap.Config config) {
        Bitmap output = Bitmap.createBitmap((int)input.width, (int)input.height, (Bitmap.Config)config);
        ConvertBitmap.grayToBitmap(input, output, null);
        return output;
    }

    public static Bitmap grayToBitmap(GrayF32 input, Bitmap.Config config) {
        Bitmap output = Bitmap.createBitmap((int)input.width, (int)input.height, (Bitmap.Config)config);
        ConvertBitmap.grayToBitmap(input, output, null);
        return output;
    }
}

