/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android.camera;

import android.graphics.Canvas;
import android.hardware.Camera;
import android.view.View;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.android.camera.VideoProcessing;
import boofcv.core.encoding.ConvertNV21;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;

public abstract class VideoRenderProcessing<T extends ImageBase<T>>
extends Thread
implements VideoProcessing {
    ImageType<T> imageType;
    T image;
    T image2;
    volatile boolean requestStop = false;
    volatile boolean running = false;
    protected int outputWidth;
    protected int outputHeight;
    protected View view;
    Thread thread;
    protected final Object lockGui = new Object();
    protected final Object lockConvert = new Object();
    protected double scale;
    protected double tranX;
    protected double tranY;
    boolean flipHorizontal;
    int previewRotation;

    protected VideoRenderProcessing(ImageType<T> imageType) {
        this.imageType = imageType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(View view, Camera camera, Camera.CameraInfo info, int previewRotation) {
        Object object = this.lockGui;
        synchronized (object) {
            this.view = view;
            this.flipHorizontal = info.facing == 1;
            this.previewRotation = previewRotation;
            Camera.Size size = camera.getParameters().getPreviewSize();
            this.outputWidth = size.width;
            this.outputHeight = size.height;
            this.declareImages(size.width, size.height);
        }
        this.running = true;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDraw(Canvas canvas) {
        Object object = this.lockGui;
        synchronized (object) {
            if (this.image == null) {
                return;
            }
            int w = this.view.getWidth();
            int h = this.view.getHeight();
            double scaleX = (double)w / (double)this.outputWidth;
            double scaleY = (double)h / (double)this.outputHeight;
            this.scale = Math.min(scaleX, scaleY);
            this.tranX = ((double)w - this.scale * (double)this.outputWidth) / 2.0;
            this.tranY = ((double)h - this.scale * (double)this.outputHeight) / 2.0;
            canvas.translate((float)this.tranX, (float)this.tranY);
            canvas.scale((float)this.scale, (float)this.scale);
            this.render(canvas, this.scale);
        }
    }

    protected void imageToOutput(double x, double y, Point2D_F64 pt) {
        pt.x = x / this.scale - this.tranX / this.scale;
        pt.y = y / this.scale - this.tranY / this.scale;
    }

    protected void outputToImage(double x, double y, Point2D_F64 pt) {
        pt.x = x * this.scale + this.tranX;
        pt.y = y * this.scale + this.tranY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void convertPreview(byte[] bytes, Camera camera) {
        if (this.thread == null) {
            return;
        }
        Object object = this.lockConvert;
        synchronized (object) {
            if (this.imageType.getFamily() == ImageType.Family.GRAY) {
                ConvertNV21.nv21ToGray((byte[])bytes, (int)((ImageBase)this.image).width, (int)((ImageBase)this.image).height, (ImageGray)((ImageGray)this.image), this.image.getClass());
            } else if (this.imageType.getFamily() == ImageType.Family.PLANAR) {
                if (this.imageType.getDataType() == ImageDataType.U8) {
                    ConvertNV21.nv21TPlanarRgb_U8((byte[])bytes, (int)((ImageBase)this.image).width, (int)((ImageBase)this.image).height, (Planar)((Planar)this.image));
                } else {
                    if (this.imageType.getDataType() != ImageDataType.F32) throw new RuntimeException("Oh Crap");
                    ConvertNV21.nv21ToPlanarRgb_F32((byte[])bytes, (int)((ImageBase)this.image).width, (int)((ImageBase)this.image).height, (Planar)((Planar)this.image));
                }
            } else {
                if (this.imageType.getFamily() != ImageType.Family.INTERLEAVED) throw new RuntimeException("Unexpected image type: " + this.imageType);
                if (this.imageType.getDataType() == ImageDataType.U8) {
                    ConvertNV21.nv21ToInterleaved((byte[])bytes, (int)((ImageBase)this.image).width, (int)((ImageBase)this.image).height, (InterleavedU8)((InterleavedU8)this.image));
                } else {
                    if (this.imageType.getDataType() != ImageDataType.F32) throw new RuntimeException("Oh Crap");
                    ConvertNV21.nv21ToInterleaved((byte[])bytes, (int)((ImageBase)this.image).width, (int)((ImageBase)this.image).height, (InterleavedF32)((InterleavedF32)this.image));
                }
            }
            if (this.previewRotation == 180) {
                if (this.flipHorizontal) {
                    GImageMiscOps.flipVertical(this.image);
                } else {
                    GImageMiscOps.flipVertical(this.image);
                    GImageMiscOps.flipHorizontal(this.image);
                }
            } else if (this.flipHorizontal) {
                GImageMiscOps.flipHorizontal(this.image);
            }
        }
        this.thread.interrupt();
    }

    @Override
    public void stopProcessing() {
        if (this.thread == null) {
            return;
        }
        this.requestStop = true;
        while (this.running) {
            this.thread.interrupt();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        while (!this.requestStop) {
            Object object = this.thread;
            synchronized (object) {
                try {
                    this.wait();
                    if (this.requestStop) {
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = this.lockConvert;
            synchronized (object) {
                T tmp = this.image;
                this.image = this.image2;
                this.image2 = tmp;
            }
            this.process(this.image2);
            this.view.postInvalidate();
        }
        this.running = false;
    }

    public double getScale() {
        return this.scale;
    }

    public double getTranX() {
        return this.tranX;
    }

    public double getTranY() {
        return this.tranY;
    }

    protected abstract void process(T var1);

    protected abstract void render(Canvas var1, double var2);

    protected void declareImages(int width, int height) {
        this.image = this.imageType.createImage(width, height);
        this.image2 = this.imageType.createImage(width, height);
    }
}

