/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import java.io.IOException;

public class CameraPreview
extends ViewGroup
implements SurfaceHolder.Callback {
    private final String TAG = "CameraPreview";
    SurfaceView mSurfaceView;
    SurfaceHolder mHolder;
    Camera mCamera;
    Camera.PreviewCallback previewCallback;
    boolean hidden;

    public CameraPreview(Context context, Camera.PreviewCallback previewCallback, boolean hidden) {
        super(context);
        this.previewCallback = previewCallback;
        this.hidden = hidden;
        this.mSurfaceView = new SurfaceView(context);
        this.addView((View)this.mSurfaceView);
        this.mHolder = this.mSurfaceView.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
    }

    public void setCamera(Camera camera) {
        this.mCamera = camera;
        if (this.mCamera != null) {
            this.startPreview();
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.hidden) {
            this.setMeasuredDimension(2, 2);
        } else {
            int width = CameraPreview.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
            int height = CameraPreview.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
            this.setMeasuredDimension(width, height);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mCamera == null) {
            return;
        }
        if (changed && this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            int width = r - l;
            int height = b - t;
            Camera.Size size = this.mCamera.getParameters().getPreviewSize();
            int previewHeight = size.height;
            int previewWidth = size.width;
            if (width * previewHeight > height * previewWidth) {
                int scaledChildWidth = previewWidth * height / previewHeight;
                l = (width - scaledChildWidth) / 2;
                t = 0;
                r = (width + scaledChildWidth) / 2;
                b = height;
            } else {
                int scaledChildHeight = previewHeight * width / previewWidth;
                l = 0;
                t = (height - scaledChildHeight) / 2;
                r = width;
                b = (height + scaledChildHeight) / 2;
            }
            child.layout(l, t, r, b);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        try {
            if (this.mCamera != null) {
                this.mCamera.setPreviewDisplay(holder);
            }
        }
        catch (IOException exception) {
            Log.e((String)"CameraPreview", (String)"IOException caused by setPreviewDisplay()", (Throwable)exception);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        if (this.mCamera == null) {
            return;
        }
        if (this.mHolder.getSurface() == null) {
            return;
        }
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startPreview();
    }

    private void startPreview() {
        try {
            this.mCamera.setPreviewDisplay(this.mHolder);
            this.mCamera.setPreviewCallback(this.previewCallback);
            this.mCamera.startPreview();
        }
        catch (Exception e) {
            Log.e((String)"CameraPreview", (String)("Error starting camera preview: " + e.getMessage()));
        }
    }
}

