/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android;

import android.graphics.Bitmap;
import boofcv.alg.color.ColorFormat;
import boofcv.android.BOverrideConvertAndroid;
import boofcv.android.ImplConvertBitmap;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ConvertBitmap {
    public static byte[] declareStorage(Bitmap input, byte[] storage) {
        int byteCount = input.getConfig() == Bitmap.Config.ARGB_8888 ? 4 : 2;
        int length = input.getWidth() * input.getHeight() * byteCount;
        if (storage == null || storage.length < length) {
            return new byte[length];
        }
        return storage;
    }

    public static <T extends ImageBase<T>> void bitmapToBoof(Bitmap input, T output, byte[] storage) {
        if (BOverrideConvertAndroid.invokeBitmapToBoof(input, output, storage)) {
            return;
        }
        switch (output.getImageType().getFamily()) {
            case GRAY: {
                if (output.getClass() == GrayF32.class) {
                    ConvertBitmap.bitmapToGray(input, (GrayF32)output, storage);
                    break;
                }
                if (output.getClass() == GrayU8.class) {
                    ConvertBitmap.bitmapToGray(input, (GrayU8)output, storage);
                    break;
                }
                throw new IllegalArgumentException("Unsupported BoofCV Image Type");
            }
            case PLANAR: {
                Planar pl = (Planar)output;
                ConvertBitmap.bitmapToPlanar(input, pl, pl.getBandType(), storage);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported BoofCV Image Type");
            }
        }
    }

    public static <T extends ImageGray<T>> T bitmapToGray(Bitmap input, T output, Class<T> imageType, byte[] storage) {
        if (imageType == GrayF32.class) {
            return (T)ConvertBitmap.bitmapToGray(input, (GrayF32)output, storage);
        }
        if (imageType == GrayU8.class) {
            return (T)ConvertBitmap.bitmapToGray(input, (GrayU8)output, storage);
        }
        throw new IllegalArgumentException("Unsupported BoofCV Image Type");
    }

    public static GrayU8 bitmapToGray(Bitmap input, GrayU8 output, byte[] storage) {
        if (output == null) {
            output = new GrayU8(input.getWidth(), input.getHeight());
        } else {
            output.reshape(input.getWidth(), input.getHeight());
        }
        if (storage == null) {
            storage = ConvertBitmap.declareStorage(input, null);
        }
        input.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(storage));
        ImplConvertBitmap.arrayToGray(storage, input.getConfig(), output);
        return output;
    }

    public static GrayF32 bitmapToGray(Bitmap input, GrayF32 output, byte[] storage) {
        if (output == null) {
            output = new GrayF32(input.getWidth(), input.getHeight());
        } else {
            output.reshape(input.getWidth(), input.getHeight());
        }
        if (storage == null) {
            storage = ConvertBitmap.declareStorage(input, null);
        }
        input.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(storage));
        ImplConvertBitmap.arrayToGray(storage, input.getConfig(), output);
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> bitmapToPlanar(Bitmap input, Planar<T> output, Class<T> type, byte[] storage) {
        if (output == null) {
            output = new Planar(type, input.getWidth(), input.getHeight(), 3);
        } else {
            int numBands = Math.min(4, Math.max(3, output.getNumBands()));
            output.reshape(input.getWidth(), input.getHeight(), numBands);
        }
        if (storage == null) {
            storage = ConvertBitmap.declareStorage(input, null);
        }
        input.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(storage));
        if (type == GrayU8.class) {
            ImplConvertBitmap.arrayToPlanar_U8(storage, input.getConfig(), (Planar<GrayU8>)output);
        } else if (type == GrayF32.class) {
            ImplConvertBitmap.arrayToPlanar_F32(storage, input.getConfig(), (Planar<GrayF32>)output);
        } else {
            throw new IllegalArgumentException("Unsupported BoofCV Type");
        }
        return output;
    }

    public static void boofToBitmap(ImageBase input, Bitmap output, byte[] storage) {
        if (BOverrideConvertAndroid.invokeBoofToBitmap(ColorFormat.RGB, input, output, storage)) {
            return;
        }
        if (input instanceof Planar) {
            ConvertBitmap.planarToBitmap((Planar)input, output, storage);
        } else if (input instanceof ImageGray) {
            ConvertBitmap.grayToBitmap((ImageGray)input, output, storage);
        } else if (input instanceof ImageInterleaved) {
            ConvertBitmap.interleavedToBitmap((ImageInterleaved)input, output, storage);
        } else {
            throw new IllegalArgumentException("Unsupported input image type");
        }
    }

    public static void boofToBitmap(ColorFormat color, ImageBase input, Bitmap output, byte[] storage) {
        if (BOverrideConvertAndroid.invokeBoofToBitmap(color, input, output, storage)) {
            return;
        }
        if (input instanceof ImageGray) {
            ConvertBitmap.grayToBitmap((ImageGray)input, output, storage);
        }
        switch (color) {
            case RGB: {
                ConvertBitmap.boofToBitmap(input, output, storage);
                return;
            }
            case YUV: {
                if (!(input instanceof ImageInterleaved)) break;
                ConvertBitmap.interleavedYuvToBitmap((ImageInterleaved)input, output, storage);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported input image type");
    }

    public static void grayToBitmap(ImageGray input, Bitmap output, byte[] storage) {
        if (input instanceof GrayU8) {
            ConvertBitmap.grayToBitmap((GrayU8)input, output, storage);
        } else if (input instanceof GrayF32) {
            ConvertBitmap.grayToBitmap((GrayF32)input, output, storage);
        } else {
            throw new IllegalArgumentException("Unsupported BoofCV Type: " + input);
        }
    }

    public static void grayToBitmap(GrayU8 input, Bitmap output, byte[] storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        if (storage == null) {
            storage = ConvertBitmap.declareStorage(output, null);
        }
        ImplConvertBitmap.grayToArray(input, storage, output.getConfig());
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void grayToBitmap(GrayF32 input, Bitmap output, byte[] storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        if (storage == null) {
            storage = ConvertBitmap.declareStorage(output, null);
        }
        ImplConvertBitmap.grayToArray(input, storage, output.getConfig());
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static <T extends ImageGray<T>> void planarToBitmap(Planar<T> input, Bitmap output, byte[] storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        if (storage == null) {
            storage = ConvertBitmap.declareStorage(output, null);
        }
        if (input.getBandType() == GrayU8.class) {
            ImplConvertBitmap.planarToArray_U8(input, storage, output.getConfig());
        } else if (input.getBandType() == GrayF32.class) {
            ImplConvertBitmap.planarToArray_F32(input, storage, output.getConfig());
        } else {
            throw new IllegalArgumentException("Unsupported BoofCV Type");
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static <T extends ImageInterleaved<T>> void interleavedToBitmap(T input, Bitmap output, byte[] storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        if (storage == null) {
            storage = ConvertBitmap.declareStorage(output, null);
        }
        if (input.getImageType().getDataType() == ImageDataType.U8) {
            ImplConvertBitmap.interleavedToArray((InterleavedU8)input, storage, output.getConfig());
        } else if (input.getImageType().getDataType() == ImageDataType.F32) {
            ImplConvertBitmap.interleavedToArray((InterleavedF32)input, storage, output.getConfig());
        } else {
            throw new IllegalArgumentException("Unsupported BoofCV Type");
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static <T extends ImageInterleaved<T>> void interleavedYuvToBitmap(T input, Bitmap output, byte[] storage) {
        if (output.getWidth() != input.getWidth() || output.getHeight() != input.getHeight()) {
            throw new IllegalArgumentException("Image shapes are not the same");
        }
        if (storage == null) {
            storage = ConvertBitmap.declareStorage(output, null);
        }
        if (input.getImageType().getDataType() == ImageDataType.U8) {
            switch (output.getConfig()) {
                case ARGB_8888: {
                    ImplConvertBitmap.interleavedYuvToArgb8888((InterleavedU8)input, storage);
                    output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
                    return;
                }
                case RGB_565: {
                    ImplConvertBitmap.interleavedYuvToRGB565((InterleavedU8)input, storage);
                    output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported BoofCV Type");
    }

    public static Bitmap grayToBitmap(GrayU8 input, Bitmap.Config config) {
        Bitmap output = Bitmap.createBitmap((int)input.width, (int)input.height, (Bitmap.Config)config);
        ConvertBitmap.grayToBitmap(input, output, null);
        return output;
    }

    public static Bitmap grayToBitmap(GrayF32 input, Bitmap.Config config) {
        Bitmap output = Bitmap.createBitmap((int)input.width, (int)input.height, (Bitmap.Config)config);
        ConvertBitmap.grayToBitmap(input, output, null);
        return output;
    }
}

