/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.system.plugin.release.util;

import java.util.ArrayList;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.namespace.QName;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;


public final class DOMUtils {
    
    public static Element getFirstChildElement(Element parent) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            if (nodeList.item(i).getNodeType() == Node.ELEMENT_NODE) {
                return (Element)nodeList.item(i);
            }
        }
        return null;
    }

    /**
     * Returns first encountered element with given qualified name within context of parent
     * element.
     * @param parent
     * @param childName
     *        qualified name of child. note that wild card '*' may be set as value for
     *        namespaceURI or localName. For an element with no namespace, leave ns uri
     *        null.
     * @return
     */
    public static Element getChildElement(Element parent, QName childName) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            if (nodeList.item(i).getNodeType() != Node.ELEMENT_NODE) {
                continue;
            }
            Element element = (Element)nodeList.item(i);
            if (childName.getNamespaceURI().equals(XMLConstants.NULL_NS_URI)) {
                if (element.getNamespaceURI() != null) {
                    continue;
                }
            } else {
                if (element.getNamespaceURI() == null) {
                    continue;
                }
                if (!childName.getNamespaceURI().equals("*")
                        && !element.getNamespaceURI().equals(childName.getNamespaceURI())) {
                    continue;
                }
            }
            if (!childName.getLocalPart().equals("*") && !element.getLocalName().equals(childName.getLocalPart())) {
                continue;
            }
            return element;
        }
        return null;
    }

    /**
     * Returns all child elements with given qualified name within context of parent element.
     * @param parent
     * @param childName
     *        qualified name of child. note that wild card '*' may be set as value for
     *        namespaceURI or localName. For an element with no namespace, set ns uri
     *        to null.
     * @return
     */
    public static List<Element> getChildElements(Element parent, QName childName) {
        List<Element> answer = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            if (nodeList.item(i).getNodeType() != Node.ELEMENT_NODE) {
                continue;
            }
            Element element = (Element)nodeList.item(i);
            if (childName.getNamespaceURI().equals(XMLConstants.NULL_NS_URI)) {
                if (element.getNamespaceURI() != null) {
                    continue;
                }
            } else {
                if (element.getNamespaceURI() == null) {
                    continue;
                }
                if (!childName.getNamespaceURI().equals("*")
                        && !element.getNamespaceURI().equals(childName.getNamespaceURI())) {
                    continue;
                }
            }
            if (!childName.getLocalPart().equals("*") && !element.getLocalName().equals(childName.getLocalPart())) {
                continue;
            }
            answer.add(element);
        }
        return answer;
    }

    public static String getText(Element element) {
        if (element == null || !element.hasChildNodes()) {
            return null;
        }
        try {
            Text textNode = (Text)element.getFirstChild();
            return textNode.getData();
        } catch (ClassCastException ce) {
        }
        return null;
    }

    static class UnresolvedPrefixException extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnresolvedPrefixException(String message) {
            super(message);
        }
    }

}
