/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.system.plugin.release;

import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.SystemPathUpdater;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.VersionTagUpdater;

/**
 * FTP's the installation artifacts to the servers, commits the checked out modules, tags the
 * checked out modules in scm with released version, releases all open source artifacts to
 * public maven repository, updates all occurrences of released version to SNAPSHOT, commits
 * the changes, installs snapshot versions to snapshot repository, allows commit access to
 * contributors.
 * 
 * @aggregator
 * @goal commit
 */
public class ReleaseCommitMojo extends AbstractMojo {

    public static String SNAPSHOT = "SNAPSHOT";

    /**
     * @parameter expression="${reactorProjects}"
     * @required
     * @readonly
     */
    private List<?> reactorProjects;
    
    /*
     * (non-Javadoc)
     * @see org.apache.maven.plugin.AbstractMojo#execute()
     */
    public void execute() throws MojoExecutionException {
        for (Iterator<?> i = reactorProjects.iterator(); i.hasNext();) {
            processProject((MavenProject)i.next());
        }
    }

    private void processProject(MavenProject project) throws MojoExecutionException {
        
        // retrieve the released version which we will revert back
        // to snapshot version
        
        String fromVersion = System.getProperty("fromVersion");
        if (fromVersion == null) {
            throw new MojoExecutionException("System Property 'fromVersion' not set.");
        }

        VersionTagUpdater.updateProject(project, fromVersion, SNAPSHOT);
        SystemPathUpdater.updateProject(project, fromVersion, SNAPSHOT);

    }

}