/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.HttpDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexingDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(MultiplexingDiscovery.class);
    protected final List<PeerDiscovery> seeds;
    protected final NetworkParameters netParams;
    private volatile ExecutorService vThreadPool;
    private final boolean parallelQueries;
    private final boolean shufflePeers;

    public static MultiplexingDiscovery forServices(NetworkParameters params, long services) {
        return MultiplexingDiscovery.forServices(params, services, true, true);
    }

    public static MultiplexingDiscovery forServices(NetworkParameters params, long services, boolean parallelQueries, boolean shufflePeers) {
        String[] dnsSeeds;
        ArrayList<PeerDiscovery> discoveries = new ArrayList<PeerDiscovery>();
        HttpDiscovery.Details[] httpSeeds = params.getHttpSeeds();
        if (httpSeeds != null) {
            OkHttpClient httpClient = new OkHttpClient();
            for (HttpDiscovery.Details httpSeed : httpSeeds) {
                discoveries.add(new HttpDiscovery(params, httpSeed, httpClient));
            }
        }
        if ((dnsSeeds = params.getDnsSeeds()) != null) {
            for (String dnsSeed : dnsSeeds) {
                discoveries.add(new DnsDiscovery.DnsSeedDiscovery(params, dnsSeed));
            }
        }
        return new MultiplexingDiscovery(params, discoveries, parallelQueries, shufflePeers);
    }

    public MultiplexingDiscovery(NetworkParameters params, List<PeerDiscovery> seeds) {
        this(params, seeds, true, true);
    }

    private MultiplexingDiscovery(NetworkParameters params, List<PeerDiscovery> seeds, boolean parallelQueries, boolean shufflePeers) {
        Preconditions.checkArgument((!seeds.isEmpty() ? 1 : 0) != 0);
        this.netParams = params;
        this.seeds = seeds;
        this.parallelQueries = parallelQueries;
        this.shufflePeers = shufflePeers;
    }

    @Override
    public List<InetSocketAddress> getPeers(final long services, final long timeoutValue, final TimeUnit timeoutUnit) throws PeerDiscoveryException {
        this.vThreadPool = this.createExecutor();
        try {
            ArrayList<Callable<List<InetSocketAddress>>> tasks = new ArrayList<Callable<List<InetSocketAddress>>>();
            if (this.parallelQueries) {
                for (final PeerDiscovery seed : this.seeds) {
                    tasks.add(new Callable<List<InetSocketAddress>>(){

                        @Override
                        public List<InetSocketAddress> call() throws Exception {
                            return seed.getPeers(services, timeoutValue, timeoutUnit);
                        }
                    });
                }
            } else {
                tasks.add(new Callable<List<InetSocketAddress>>(){

                    @Override
                    public List<InetSocketAddress> call() throws Exception {
                        LinkedList<InetSocketAddress> peers = new LinkedList<InetSocketAddress>();
                        for (PeerDiscovery seed : MultiplexingDiscovery.this.seeds) {
                            peers.addAll(seed.getPeers(services, timeoutValue, timeoutUnit));
                        }
                        return peers;
                    }
                });
            }
            List futures = this.vThreadPool.invokeAll(tasks, timeoutValue, timeoutUnit);
            ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
            for (int i = 0; i < futures.size(); ++i) {
                List inetAddresses;
                Future future = futures.get(i);
                if (future.isCancelled()) {
                    log.warn("Seed {}: timed out", this.parallelQueries ? this.seeds.get(i) : "any");
                    continue;
                }
                try {
                    inetAddresses = (List)future.get();
                }
                catch (ExecutionException e) {
                    log.warn("Seed {}: failed to look up: {}", this.parallelQueries ? this.seeds.get(i) : "any", (Object)e.getMessage());
                    continue;
                }
                addrs.addAll(inetAddresses);
            }
            if (addrs.size() == 0) {
                throw new PeerDiscoveryException("No peer discovery returned any results in " + timeoutUnit.toMillis(timeoutValue) + "ms. Check internet connection?");
            }
            if (this.shufflePeers) {
                Collections.shuffle(addrs);
            }
            this.vThreadPool.shutdownNow();
            ArrayList<InetSocketAddress> arrayList = addrs;
            return arrayList;
        }
        catch (InterruptedException e) {
            throw new PeerDiscoveryException(e);
        }
        finally {
            this.vThreadPool.shutdown();
        }
    }

    protected ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.seeds.size(), new ContextPropagatingThreadFactory("Multiplexing discovery"));
    }

    @Override
    public void shutdown() {
        ExecutorService tp = this.vThreadPool;
        if (tp != null) {
            tp.shutdown();
        }
    }
}

