/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;

public class StoredBlock {
    private static final int CHAIN_WORK_BYTES_V1 = 12;
    private static final int CHAIN_WORK_BYTES_V2 = 32;
    private static final int HEIGHT_BYTES = 4;
    private static final byte[] EMPTY_BYTES = new byte[32];
    public static final int COMPACT_SERIALIZED_SIZE = 96;
    public static final int COMPACT_SERIALIZED_SIZE_V2 = 116;
    private final Block header;
    private final BigInteger chainWork;
    private final int height;

    public StoredBlock(Block header, BigInteger chainWork, int height) {
        this.header = header;
        this.chainWork = chainWork;
        this.height = height;
    }

    public Block getHeader() {
        return this.header;
    }

    public BigInteger getChainWork() {
        return this.chainWork;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean moreWorkThan(StoredBlock other) {
        return this.chainWork.compareTo(other.chainWork) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredBlock other = (StoredBlock)o;
        return this.header.equals(other.header) && this.chainWork.equals(other.chainWork) && this.height == other.height;
    }

    public int hashCode() {
        return Objects.hash(this.header, this.chainWork, this.height);
    }

    public StoredBlock build(Block block) throws VerificationException {
        BigInteger chainWork = this.chainWork.add(block.getWork());
        int height = this.height + 1;
        return new StoredBlock(block, chainWork, height);
    }

    public StoredBlock getPrev(BlockStore store) throws BlockStoreException {
        return store.get(this.getHeader().getPrevBlockHash());
    }

    public void serializeCompact(ByteBuffer buffer) {
        byte[] chainWorkBytes = Utils.bigIntegerToBytes(this.getChainWork(), 12);
        if (chainWorkBytes.length < 12) {
            buffer.put(EMPTY_BYTES, 0, 12 - chainWorkBytes.length);
        }
        buffer.put(chainWorkBytes);
        buffer.putInt(this.getHeight());
        byte[] bytes = this.getHeader().unsafeBitcoinSerialize();
        buffer.put(bytes, 0, 80);
    }

    public void serializeCompactV2(ByteBuffer buffer) {
        byte[] chainWorkBytes = Utils.bigIntegerToBytes(this.getChainWork(), 32);
        if (chainWorkBytes.length < 32) {
            buffer.put(EMPTY_BYTES, 0, 32 - chainWorkBytes.length);
        }
        buffer.put(chainWorkBytes);
        buffer.putInt(this.getHeight());
        byte[] bytes = this.getHeader().unsafeBitcoinSerialize();
        buffer.put(bytes, 0, 80);
    }

    public static StoredBlock deserializeCompact(NetworkParameters params, ByteBuffer buffer) throws ProtocolException {
        byte[] chainWorkBytes = new byte[12];
        buffer.get(chainWorkBytes);
        BigInteger chainWork = new BigInteger(1, chainWorkBytes);
        int height = buffer.getInt();
        byte[] header = new byte[81];
        buffer.get(header, 0, 80);
        return new StoredBlock(params.getDefaultSerializer().makeBlock(header), chainWork, height);
    }

    public static StoredBlock deserializeCompactV2(NetworkParameters params, ByteBuffer buffer) throws ProtocolException {
        byte[] chainWorkBytes = new byte[32];
        buffer.get(chainWorkBytes);
        BigInteger chainWork = new BigInteger(1, chainWorkBytes);
        int height = buffer.getInt();
        byte[] header = new byte[81];
        buffer.get(header, 0, 80);
        return new StoredBlock(params.getDefaultSerializer().makeBlock(header), chainWork, height);
    }

    public String toString() {
        return String.format(Locale.US, "Block %s at height %d: %s", this.getHeader().getHashAsString(), this.getHeight(), this.getHeader().toString());
    }
}

