/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.VarInt;

public abstract class AddressMessage
extends Message {
    protected static final long MAX_ADDRESSES = 1000L;
    protected List<PeerAddress> addresses;

    AddressMessage(NetworkParameters params, byte[] payload, int offset, MessageSerializer serializer, int length) throws ProtocolException {
        super(params, payload, offset, serializer, length);
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        if (this.addresses == null) {
            return;
        }
        stream.write(new VarInt(this.addresses.size()).encode());
        for (PeerAddress addr : this.addresses) {
            addr.bitcoinSerialize(stream);
        }
    }

    public abstract void addAddress(PeerAddress var1);

    public void removeAddress(int index) {
        this.unCache();
        PeerAddress address = this.addresses.remove(index);
        address.setParent(null);
        this.length = Integer.MIN_VALUE;
    }

    public List<PeerAddress> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }
}

