/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.util.List;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.script.Script;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.KeyChainFactory;
import org.bitcoinj.wallet.MarriedKeyChain;
import org.bitcoinj.wallet.UnreadableWalletException;

public class DefaultKeyChainFactory
implements KeyChainFactory {
    @Override
    public DeterministicKeyChain makeKeyChain(DeterministicSeed seed, KeyCrypter crypter, boolean isMarried, Script.ScriptType outputScriptType, List<ChildNumber> accountPath) {
        DeterministicKeyChain chain = isMarried ? new MarriedKeyChain(seed, crypter, outputScriptType, accountPath) : new DeterministicKeyChain(seed, crypter, outputScriptType, accountPath);
        return chain;
    }

    @Override
    public DeterministicKeyChain makeWatchingKeyChain(DeterministicKey accountKey, boolean isFollowingKey, boolean isMarried, Script.ScriptType outputScriptType) throws UnreadableWalletException {
        DeterministicKeyChain chain = isMarried ? new MarriedKeyChain(accountKey, outputScriptType) : (isFollowingKey ? ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().watchAndFollow(accountKey)).outputScriptType(outputScriptType)).build() : ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().watch(accountKey)).outputScriptType(outputScriptType)).build());
        return chain;
    }

    @Override
    public DeterministicKeyChain makeSpendingKeyChain(DeterministicKey accountKey, boolean isMarried, Script.ScriptType outputScriptType) throws UnreadableWalletException {
        DeterministicKeyChain chain = isMarried ? new MarriedKeyChain(accountKey, outputScriptType) : ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().spend(accountKey)).outputScriptType(outputScriptType)).build();
        return chain;
    }
}

