/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.utils;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.bitcoinj.utils.TaggableObject;

public class BaseTaggableObject
implements TaggableObject {
    protected final Map<String, ByteString> tags = new HashMap<String, ByteString>();

    @Override
    @Nullable
    public synchronized ByteString maybeGetTag(String tag) {
        return this.tags.get(tag);
    }

    @Override
    public ByteString getTag(String tag) {
        ByteString b = this.maybeGetTag(tag);
        if (b == null) {
            throw new IllegalArgumentException("Unknown tag " + tag);
        }
        return b;
    }

    @Override
    public synchronized void setTag(String tag, ByteString value) {
        Preconditions.checkNotNull((Object)tag);
        Preconditions.checkNotNull((Object)value);
        this.tags.put(tag, value);
    }

    @Override
    public synchronized Map<String, ByteString> getTags() {
        return new HashMap<String, ByteString>(this.tags);
    }
}

