/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Joiner;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;

public class VersionMessage
extends Message {
    public static final String BITCOINJ_VERSION = "0.16.4";
    public static final String LIBRARY_SUBVER = "/bitcoinj:0.16.4/";
    public static final int NODE_NETWORK = 1;
    public static final int NODE_GETUTXOS = 2;
    public static final int NODE_BLOOM = 4;
    public static final int NODE_WITNESS = 8;
    public static final int NODE_COMPACT_FILTERS = 64;
    public static final int NODE_NETWORK_LIMITED = 1024;
    public static final int NODE_P2P_V2 = 2048;
    public static final int NODE_BITCOIN_CASH = 32;
    public int clientVersion;
    public long localServices;
    public long time;
    public PeerAddress receivingAddr;
    public PeerAddress fromAddr;
    public String subVer;
    public long bestHeight;
    public boolean relayTxesBeforeFilter;

    public VersionMessage(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0);
    }

    public VersionMessage(NetworkParameters params, int newBestHeight) {
        super(params);
        this.clientVersion = this.serializer.getProtocolVersion();
        this.localServices = 0L;
        this.time = Utils.currentTimeSeconds();
        InetAddress localhost = InetAddresses.forString((String)"127.0.0.1");
        MessageSerializer serializer = this.serializer.withProtocolVersion(0);
        this.receivingAddr = new PeerAddress(params, localhost, params.getPort(), BigInteger.ZERO, serializer);
        this.receivingAddr.setParent(this);
        this.fromAddr = new PeerAddress(params, localhost, params.getPort(), BigInteger.ZERO, serializer);
        this.fromAddr.setParent(this);
        this.subVer = LIBRARY_SUBVER;
        this.bestHeight = newBestHeight;
        this.relayTxesBeforeFilter = true;
    }

    @Override
    protected void parse() throws ProtocolException {
        this.clientVersion = (int)this.readUint32();
        this.localServices = this.readUint64().longValue();
        this.time = this.readUint64().longValue();
        this.receivingAddr = new PeerAddress(this.params, this.payload, this.cursor, this, this.serializer.withProtocolVersion(0));
        this.cursor += this.receivingAddr.getMessageSize();
        if (this.clientVersion >= 106) {
            this.fromAddr = new PeerAddress(this.params, this.payload, this.cursor, this, this.serializer.withProtocolVersion(0));
            this.cursor += this.fromAddr.getMessageSize();
            this.readUint64();
            this.subVer = this.readStr();
            this.bestHeight = this.readUint32();
            this.relayTxesBeforeFilter = this.clientVersion >= this.params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.BLOOM_FILTER) ? this.readBytes(1)[0] != 0 : true;
        } else {
            this.fromAddr = null;
            this.subVer = "";
            this.bestHeight = 0L;
            this.relayTxesBeforeFilter = true;
        }
        this.length = this.cursor - this.offset;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream buf) throws IOException {
        Utils.uint32ToByteStreamLE(this.clientVersion, buf);
        Utils.uint32ToByteStreamLE(this.localServices, buf);
        Utils.uint32ToByteStreamLE(this.localServices >> 32, buf);
        Utils.uint32ToByteStreamLE(this.time, buf);
        Utils.uint32ToByteStreamLE(this.time >> 32, buf);
        this.receivingAddr.bitcoinSerializeToStream(buf);
        this.fromAddr.bitcoinSerializeToStream(buf);
        Utils.uint32ToByteStreamLE(0L, buf);
        Utils.uint32ToByteStreamLE(0L, buf);
        byte[] subVerBytes = this.subVer.getBytes(StandardCharsets.UTF_8);
        buf.write(new VarInt(subVerBytes.length).encode());
        buf.write(subVerBytes);
        Utils.uint32ToByteStreamLE(this.bestHeight, buf);
        if (this.clientVersion >= this.params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.BLOOM_FILTER)) {
            buf.write(this.relayTxesBeforeFilter ? 1 : 0);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionMessage other = (VersionMessage)o;
        return other.bestHeight == this.bestHeight && other.clientVersion == this.clientVersion && other.localServices == this.localServices && other.time == this.time && other.subVer.equals(this.subVer) && other.receivingAddr.equals(this.receivingAddr) && other.fromAddr.equals(this.fromAddr) && other.relayTxesBeforeFilter == this.relayTxesBeforeFilter;
    }

    public int hashCode() {
        return Objects.hash(this.bestHeight, this.clientVersion, this.localServices, this.time, this.subVer, this.receivingAddr, this.fromAddr, this.relayTxesBeforeFilter);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("\n");
        builder.append("client version: ").append(this.clientVersion).append("\n");
        builder.append("local services: ").append(this.localServices);
        if (this.localServices != 0L) {
            builder.append(" (").append(VersionMessage.toStringServices(this.localServices)).append(")");
        }
        builder.append("\n");
        builder.append("time:           ").append(this.time).append("\n");
        builder.append("receiving addr: ").append(this.receivingAddr).append("\n");
        builder.append("from addr:      ").append(this.fromAddr).append("\n");
        builder.append("sub version:    ").append(this.subVer).append("\n");
        builder.append("best height:    ").append(this.bestHeight).append("\n");
        builder.append("delay tx relay: ").append(!this.relayTxesBeforeFilter).append("\n");
        return builder.toString();
    }

    public VersionMessage duplicate() {
        VersionMessage v = new VersionMessage(this.params, (int)this.bestHeight);
        v.clientVersion = this.clientVersion;
        v.localServices = this.localServices;
        v.time = this.time;
        v.receivingAddr = this.receivingAddr;
        v.fromAddr = this.fromAddr;
        v.subVer = this.subVer;
        v.relayTxesBeforeFilter = this.relayTxesBeforeFilter;
        return v;
    }

    public void appendToSubVer(String name, String version, @Nullable String comments) {
        VersionMessage.checkSubVerComponent(name);
        VersionMessage.checkSubVerComponent(version);
        if (comments != null) {
            VersionMessage.checkSubVerComponent(comments);
            this.subVer = this.subVer.concat(String.format(Locale.US, "%s:%s(%s)/", name, version, comments));
        } else {
            this.subVer = this.subVer.concat(String.format(Locale.US, "%s:%s/", name, version));
        }
    }

    private static void checkSubVerComponent(String component) {
        if (component.contains("/") || component.contains("(") || component.contains(")")) {
            throw new IllegalArgumentException("name contains invalid characters");
        }
    }

    public boolean isPingPongSupported() {
        return this.clientVersion >= this.params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.PONG);
    }

    public boolean isBloomFilteringSupported() {
        if (this.clientVersion >= this.params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.BLOOM_FILTER) && this.clientVersion < this.params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.BLOOM_FILTER_BIP111)) {
            return true;
        }
        return (this.localServices & 4L) == 4L;
    }

    public boolean isGetUTXOsSupported() {
        return this.clientVersion >= 70002 && (this.localServices & 2L) == 2L;
    }

    public boolean isWitnessSupported() {
        return (this.localServices & 8L) == 8L;
    }

    public boolean hasBlockChain() {
        return (this.localServices & 1L) == 1L;
    }

    public boolean hasLimitedBlockChain() {
        return this.hasBlockChain() || (this.localServices & 0x400L) == 1024L;
    }

    public static String toStringServices(long services) {
        LinkedList<String> strings = new LinkedList<String>();
        if ((services & 1L) == 1L) {
            strings.add("NETWORK");
            services &= 0xFFFFFFFFFFFFFFFEL;
        }
        if ((services & 2L) == 2L) {
            strings.add("GETUTXOS");
            services &= 0xFFFFFFFFFFFFFFFDL;
        }
        if ((services & 4L) == 4L) {
            strings.add("BLOOM");
            services &= 0xFFFFFFFFFFFFFFFBL;
        }
        if ((services & 8L) == 8L) {
            strings.add("WITNESS");
            services &= 0xFFFFFFFFFFFFFFF7L;
        }
        if ((services & 0x40L) == 64L) {
            strings.add("COMPACT_FILTERS");
            services &= 0xFFFFFFFFFFFFFFBFL;
        }
        if ((services & 0x400L) == 1024L) {
            strings.add("NETWORK_LIMITED");
            services &= 0xFFFFFFFFFFFFFBFFL;
        }
        if ((services & 0x800L) == 2048L) {
            strings.add("P2P_V2");
            services &= 0xFFFFFFFFFFFFF7FFL;
        }
        if (services != 0L) {
            strings.add("remaining: " + Long.toBinaryString(services));
        }
        return Joiner.on((String)", ").join(strings);
    }
}

