/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.core.Utils;

public class TransactionOutputChanges {
    public final List<UTXO> txOutsCreated;
    public final List<UTXO> txOutsSpent;

    public TransactionOutputChanges(List<UTXO> txOutsCreated, List<UTXO> txOutsSpent) {
        this.txOutsCreated = txOutsCreated;
        this.txOutsSpent = txOutsSpent;
    }

    public TransactionOutputChanges(InputStream in) throws IOException {
        int numOutsCreated = (int)Utils.readUint32FromStream(in);
        this.txOutsCreated = new LinkedList<UTXO>();
        for (int i = 0; i < numOutsCreated; ++i) {
            this.txOutsCreated.add(UTXO.fromStream(in));
        }
        int numOutsSpent = (int)Utils.readUint32FromStream(in);
        this.txOutsSpent = new LinkedList<UTXO>();
        for (int i = 0; i < numOutsSpent; ++i) {
            this.txOutsSpent.add(UTXO.fromStream(in));
        }
    }

    public void serializeToStream(OutputStream bos) throws IOException {
        int numOutsCreated = this.txOutsCreated.size();
        Utils.uint32ToByteStreamLE(numOutsCreated, bos);
        for (UTXO output : this.txOutsCreated) {
            output.serializeToStream(bos);
        }
        int numOutsSpent = this.txOutsSpent.size();
        Utils.uint32ToByteStreamLE(numOutsSpent, bos);
        for (UTXO output : this.txOutsSpent) {
            output.serializeToStream(bos);
        }
    }
}

