/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.util.ArrayList;
import org.bitcoinj.core.AddressMessage;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;

public class AddressV1Message
extends AddressMessage {
    AddressV1Message(NetworkParameters params, byte[] payload, int offset, MessageSerializer serializer, int length) throws ProtocolException {
        super(params, payload, offset, serializer, length);
    }

    AddressV1Message(NetworkParameters params, byte[] payload, MessageSerializer serializer, int length) throws ProtocolException {
        super(params, payload, 0, serializer, length);
    }

    AddressV1Message(NetworkParameters params, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset, params.getDefaultSerializer(), Integer.MIN_VALUE);
    }

    AddressV1Message(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0, params.getDefaultSerializer(), Integer.MIN_VALUE);
    }

    @Override
    protected void parse() throws ProtocolException {
        VarInt numAddressesVarInt = this.readVarInt();
        int numAddresses = numAddressesVarInt.intValue();
        if ((long)numAddresses > 1000L) {
            throw new ProtocolException("Address message too large.");
        }
        this.addresses = new ArrayList(numAddresses);
        MessageSerializer serializer = this.serializer.withProtocolVersion(1);
        this.length = numAddressesVarInt.getSizeInBytes();
        for (int i = 0; i < numAddresses; ++i) {
            PeerAddress addr = new PeerAddress(this.params, this.payload, this.cursor, this, serializer);
            this.addresses.add(addr);
            this.cursor += addr.getMessageSize();
            this.length += addr.getMessageSize();
        }
    }

    @Override
    public void addAddress(PeerAddress address) {
        int protocolVersion = address.serializer.getProtocolVersion();
        if (protocolVersion != 1) {
            throw new IllegalStateException("invalid protocolVersion: " + protocolVersion);
        }
        this.unCache();
        address.setParent(this);
        this.addresses.add(address);
        this.length = Integer.MIN_VALUE;
    }

    public String toString() {
        return "addr: " + Utils.SPACE_JOINER.join((Iterable)this.addresses);
    }
}

