/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.KeyChain;
import org.bitcoinj.wallet.Protos;
import org.bitcoinj.wallet.RedeemData;
import org.bouncycastle.crypto.params.KeyParameter;

public class MarriedKeyChain
extends DeterministicKeyChain {
    private LinkedHashMap<ByteString, RedeemData> marriedKeysRedeemData = new LinkedHashMap();
    private List<DeterministicKeyChain> followingKeyChains;

    public static Builder<?> builder() {
        return new Builder();
    }

    protected MarriedKeyChain(DeterministicKey accountKey, Script.ScriptType outputScriptType) {
        super(accountKey, false, true, outputScriptType);
    }

    protected MarriedKeyChain(DeterministicSeed seed, KeyCrypter crypter, Script.ScriptType outputScriptType, List<ChildNumber> accountPath) {
        super(seed, crypter, outputScriptType, accountPath);
    }

    void setFollowingKeyChains(List<DeterministicKeyChain> followingKeyChains) {
        Preconditions.checkArgument((!followingKeyChains.isEmpty() ? 1 : 0) != 0);
        this.followingKeyChains = followingKeyChains;
    }

    @Override
    public boolean isMarried() {
        return true;
    }

    @Override
    public Script freshOutputScript(KeyChain.KeyPurpose purpose) {
        DeterministicKey followedKey = this.getKey(purpose);
        ImmutableList.Builder keys = ImmutableList.builder().add((Object)followedKey);
        for (DeterministicKeyChain keyChain : this.followingKeyChains) {
            DeterministicKey followingKey = keyChain.getKey(purpose);
            Preconditions.checkState((boolean)followedKey.getChildNumber().equals(followingKey.getChildNumber()), (Object)"Following keychains should be in sync");
            keys.add((Object)followingKey);
        }
        ImmutableList marriedKeys = keys.build();
        Script redeemScript = ScriptBuilder.createRedeemScript(this.sigsRequiredToSpend, (List<ECKey>)marriedKeys);
        return ScriptBuilder.createP2SHOutputScript(redeemScript);
    }

    private List<ECKey> getMarriedKeysWithFollowed(DeterministicKey followedKey) {
        ImmutableList.Builder keys = ImmutableList.builder();
        for (DeterministicKeyChain keyChain : this.followingKeyChains) {
            keyChain.maybeLookAhead();
            keys.add((Object)keyChain.getKeyByPath(followedKey.getPath()));
        }
        keys.add((Object)followedKey);
        return keys.build();
    }

    @Override
    public RedeemData getRedeemData(DeterministicKey followedKey) {
        List<ECKey> marriedKeys = this.getMarriedKeysWithFollowed(followedKey);
        Script redeemScript = ScriptBuilder.createRedeemScript(this.sigsRequiredToSpend, marriedKeys);
        return RedeemData.of(marriedKeys, redeemScript);
    }

    private void addFollowingAccountKeys(List<DeterministicKey> followingAccountKeys, int sigsRequiredToSpend) {
        Preconditions.checkArgument((sigsRequiredToSpend <= followingAccountKeys.size() + 1 ? 1 : 0) != 0, (Object)"Multisig threshold can't exceed total number of keys");
        Preconditions.checkState((this.numLeafKeysIssued() == 0 ? 1 : 0) != 0, (Object)"Active keychain already has keys in use");
        Preconditions.checkState((this.followingKeyChains == null ? 1 : 0) != 0);
        ArrayList<DeterministicKeyChain> followingKeyChains = new ArrayList<DeterministicKeyChain>();
        for (DeterministicKey key : followingAccountKeys) {
            Preconditions.checkArgument((key.getPath().size() == this.getAccountPath().size() ? 1 : 0) != 0, (Object)"Following keys have to be account keys");
            DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().watchAndFollow(key)).outputScriptType(this.getOutputScriptType())).build();
            if (this.lookaheadSize >= 0) {
                chain.setLookaheadSize(this.lookaheadSize);
            }
            if (this.lookaheadThreshold >= 0) {
                chain.setLookaheadThreshold(this.lookaheadThreshold);
            }
            followingKeyChains.add(chain);
        }
        this.sigsRequiredToSpend = sigsRequiredToSpend;
        this.followingKeyChains = followingKeyChains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLookaheadSize(int lookaheadSize) {
        this.lock.lock();
        try {
            super.setLookaheadSize(lookaheadSize);
            if (this.followingKeyChains != null) {
                for (DeterministicKeyChain followingChain : this.followingKeyChains) {
                    followingChain.setLookaheadSize(lookaheadSize);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Protos.Key> serializeToProtobuf() {
        ArrayList<Protos.Key> result = new ArrayList<Protos.Key>();
        this.lock.lock();
        try {
            for (DeterministicKeyChain chain : this.followingKeyChains) {
                result.addAll(chain.serializeMyselfToProtobuf());
            }
            result.addAll(this.serializeMyselfToProtobuf());
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    protected void formatAddresses(boolean includeLookahead, boolean includePrivateKeys, @Nullable KeyParameter aesKey, NetworkParameters params, StringBuilder builder) {
        for (DeterministicKeyChain followingChain : this.followingKeyChains) {
            builder.append("Following chain:  ").append(followingChain.getWatchingKey().serializePubB58(params)).append('\n');
        }
        builder.append('\n');
        for (RedeemData redeemData : this.marriedKeysRedeemData.values()) {
            this.formatScript(ScriptBuilder.createP2SHOutputScript(redeemData.redeemScript), builder, params);
        }
    }

    private void formatScript(Script script, StringBuilder builder, NetworkParameters params) {
        builder.append("  addr:");
        builder.append(script.getToAddress(params));
        builder.append("  hash160:");
        builder.append(Utils.HEX.encode(script.getPubKeyHash()));
        if (script.getCreationTimeSeconds() > 0L) {
            builder.append("  creationTimeSeconds:").append(script.getCreationTimeSeconds());
        }
        builder.append('\n');
    }

    @Override
    public void maybeLookAheadScripts() {
        super.maybeLookAheadScripts();
        int numLeafKeys = this.getLeafKeys().size();
        Preconditions.checkState((this.marriedKeysRedeemData.size() <= numLeafKeys ? 1 : 0) != 0, (Object)"Number of scripts is greater than number of leaf keys");
        if (this.marriedKeysRedeemData.size() == numLeafKeys) {
            return;
        }
        this.maybeLookAhead();
        for (DeterministicKey followedKey : this.getLeafKeys()) {
            RedeemData redeemData = this.getRedeemData(followedKey);
            Script scriptPubKey = ScriptBuilder.createP2SHOutputScript(redeemData.redeemScript);
            this.marriedKeysRedeemData.put(ByteString.copyFrom((byte[])scriptPubKey.getPubKeyHash()), redeemData);
        }
    }

    @Override
    @Nullable
    public RedeemData findRedeemDataByScriptHash(ByteString bytes) {
        return this.marriedKeysRedeemData.get(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BloomFilter getFilter(int size, double falsePositiveRate, long tweak) {
        BloomFilter filter;
        this.lock.lock();
        try {
            filter = new BloomFilter(size, falsePositiveRate, tweak);
            for (Map.Entry<ByteString, RedeemData> entry : this.marriedKeysRedeemData.entrySet()) {
                filter.insert(entry.getKey().toByteArray());
                filter.insert(entry.getValue().redeemScript.getProgram());
            }
        }
        finally {
            this.lock.unlock();
        }
        return filter;
    }

    @Override
    public int numBloomFilterEntries() {
        this.maybeLookAhead();
        return this.getLeafKeys().size() * 2;
    }

    public static class Builder<T extends Builder<T>>
    extends DeterministicKeyChain.Builder<T> {
        private List<DeterministicKey> followingKeys;
        private int threshold;

        protected Builder() {
        }

        public T followingKeys(List<DeterministicKey> followingKeys) {
            this.followingKeys = followingKeys;
            return (T)((Builder)this.self());
        }

        public T followingKeys(DeterministicKey followingKey, DeterministicKey ... followingKeys) {
            this.followingKeys = Lists.asList((Object)followingKey, (Object[])followingKeys);
            return (T)((Builder)this.self());
        }

        public T threshold(int threshold) {
            this.threshold = threshold;
            return (T)((Builder)this.self());
        }

        @Override
        public MarriedKeyChain build() {
            MarriedKeyChain chain;
            Preconditions.checkNotNull(this.followingKeys, (Object)"followingKeys must be provided");
            if (this.threshold == 0) {
                this.threshold = (this.followingKeys.size() + 1) / 2 + 1;
            }
            if (this.accountPath == null) {
                this.accountPath = DeterministicKeyChain.ACCOUNT_ZERO_PATH;
            }
            if (this.random != null) {
                chain = new MarriedKeyChain(new DeterministicSeed(this.random, this.bits, this.getPassphrase()), null, this.outputScriptType, this.accountPath);
            } else if (this.entropy != null) {
                chain = new MarriedKeyChain(new DeterministicSeed(this.entropy, this.getPassphrase(), this.creationTimeSecs), null, this.outputScriptType, this.accountPath);
            } else if (this.seed != null) {
                chain = new MarriedKeyChain(this.seed, null, this.outputScriptType, this.accountPath);
            } else if (this.watchingKey != null) {
                chain = new MarriedKeyChain(this.watchingKey, this.outputScriptType);
            } else {
                throw new IllegalStateException();
            }
            chain.addFollowingAccountKeys(this.followingKeys, this.threshold);
            return chain;
        }
    }
}

