/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.script;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.core.Utils;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptOpCodes;

public class ScriptChunk {
    public final int opcode;
    @Nullable
    public final byte[] data;

    public ScriptChunk(int opcode, @Nullable byte[] data) {
        this.opcode = opcode;
        this.data = data;
    }

    public boolean equalsOpCode(int opcode) {
        return opcode == this.opcode;
    }

    public boolean isOpCode() {
        return this.opcode > 78;
    }

    public boolean isPushData() {
        return this.opcode <= 96;
    }

    public int decodeOpN() {
        return Script.decodeFromOpN(this.opcode);
    }

    public boolean isShortestPossiblePushData() {
        Preconditions.checkState((boolean)this.isPushData());
        if (this.data == null) {
            return true;
        }
        if (this.data.length == 0) {
            return this.opcode == 0;
        }
        if (this.data.length == 1) {
            byte b = this.data[0];
            if (b >= 1 && b <= 16) {
                return this.opcode == 81 + b - 1;
            }
            if ((b & 0xFF) == 129) {
                return this.opcode == 79;
            }
        }
        if (this.data.length < 76) {
            return this.opcode == this.data.length;
        }
        if (this.data.length < 256) {
            return this.opcode == 76;
        }
        if (this.data.length < 65536) {
            return this.opcode == 77;
        }
        return this.opcode == 78;
    }

    public void write(OutputStream stream) throws IOException {
        if (this.isOpCode()) {
            Preconditions.checkState((this.data == null ? 1 : 0) != 0);
            stream.write(this.opcode);
        } else if (this.data != null) {
            if (this.opcode < 76) {
                Preconditions.checkState((this.data.length == this.opcode ? 1 : 0) != 0);
                stream.write(this.opcode);
            } else if (this.opcode == 76) {
                Preconditions.checkState((this.data.length <= 255 ? 1 : 0) != 0);
                stream.write(76);
                stream.write(this.data.length);
            } else if (this.opcode == 77) {
                Preconditions.checkState((this.data.length <= 65535 ? 1 : 0) != 0);
                stream.write(77);
                Utils.uint16ToByteStreamLE(this.data.length, stream);
            } else if (this.opcode == 78) {
                Preconditions.checkState(((long)this.data.length <= 520L ? 1 : 0) != 0);
                stream.write(78);
                Utils.uint32ToByteStreamLE(this.data.length, stream);
            } else {
                throw new RuntimeException("Unimplemented");
            }
            stream.write(this.data);
        } else {
            stream.write(this.opcode);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.write(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream.toByteArray();
    }

    public int size() {
        boolean opcodeLength = true;
        int pushDataSizeLength = 0;
        if (this.opcode == 76) {
            pushDataSizeLength = 1;
        } else if (this.opcode == 77) {
            pushDataSizeLength = 2;
        } else if (this.opcode == 78) {
            pushDataSizeLength = 4;
        }
        int dataLength = this.data == null ? 0 : this.data.length;
        return 1 + pushDataSizeLength + dataLength;
    }

    public String toString() {
        if (this.data == null) {
            return ScriptOpCodes.getOpCodeName(this.opcode);
        }
        return String.format("%s[%s]", ScriptOpCodes.getPushDataName(this.opcode), Utils.HEX.encode(this.data));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptChunk other = (ScriptChunk)o;
        return this.opcode == other.opcode && Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        return Objects.hash(this.opcode, Arrays.hashCode(this.data));
    }
}

