/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.math.BigInteger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.net.discovery.HttpDiscovery;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.params.UnitTestParams;
import org.bitcoinj.script.Script;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.MonetaryFormat;
import org.bitcoinj.utils.VersionTally;

public abstract class NetworkParameters {
    public static final String ID_MAINNET = "org.bitcoin.production";
    public static final String ID_TESTNET = "org.bitcoin.test";
    public static final String ID_REGTEST = "org.bitcoin.regtest";
    public static final String ID_UNITTESTNET = "org.bitcoinj.unittest";
    public static final String PAYMENT_PROTOCOL_ID_MAINNET = "main";
    public static final String PAYMENT_PROTOCOL_ID_TESTNET = "test";
    public static final String PAYMENT_PROTOCOL_ID_UNIT_TESTS = "unittest";
    public static final String PAYMENT_PROTOCOL_ID_REGTEST = "regtest";
    protected BigInteger maxTarget;
    protected int port;
    protected long packetMagic;
    protected int addressHeader;
    protected int p2shHeader;
    protected int dumpedPrivateKeyHeader;
    protected String segwitAddressHrp;
    protected int interval;
    protected int targetTimespan;
    protected int bip32HeaderP2PKHpub;
    protected int bip32HeaderP2PKHpriv;
    protected int bip32HeaderP2WPKHpub;
    protected int bip32HeaderP2WPKHpriv;
    protected int majorityEnforceBlockUpgrade;
    protected int majorityRejectBlockOutdated;
    protected int majorityWindow;
    protected String id;
    protected int spendableCoinbaseDepth;
    protected int subsidyDecreaseBlockCount;
    protected String[] dnsSeeds;
    protected int[] addrSeeds;
    protected HttpDiscovery.Details[] httpSeeds = new HttpDiscovery.Details[0];
    protected Map<Integer, Sha256Hash> checkpoints = new HashMap<Integer, Sha256Hash>();
    protected volatile transient MessageSerializer defaultSerializer = null;
    public static final int TARGET_TIMESPAN = 1209600;
    public static final int TARGET_SPACING = 600;
    public static final int INTERVAL = 2016;
    public static final int BIP16_ENFORCE_TIME = 1333238400;
    public static final long MAX_COINS = 21000000L;
    public static final Coin MAX_MONEY = Coin.COIN.multiply(21000000L);

    protected NetworkParameters() {
    }

    public String getId() {
        return this.id;
    }

    public abstract String getPaymentProtocolId();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getId().equals(((NetworkParameters)o).getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Nullable
    public static NetworkParameters fromID(String id) {
        if (id.equals(ID_MAINNET)) {
            return MainNetParams.get();
        }
        if (id.equals(ID_TESTNET)) {
            return TestNet3Params.get();
        }
        if (id.equals(ID_UNITTESTNET)) {
            return UnitTestParams.get();
        }
        if (id.equals(ID_REGTEST)) {
            return RegTestParams.get();
        }
        return null;
    }

    @Nullable
    public static NetworkParameters fromPmtProtocolID(String pmtProtocolId) {
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_MAINNET)) {
            return MainNetParams.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_TESTNET)) {
            return TestNet3Params.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_UNIT_TESTS)) {
            return UnitTestParams.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_REGTEST)) {
            return RegTestParams.get();
        }
        return null;
    }

    public int getSpendableCoinbaseDepth() {
        return this.spendableCoinbaseDepth;
    }

    public abstract void checkDifficultyTransitions(StoredBlock var1, Block var2, BlockStore var3) throws VerificationException, BlockStoreException;

    public boolean passesCheckpoint(int height, Sha256Hash hash) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash == null || checkpointHash.equals(hash);
    }

    public boolean isCheckpoint(int height) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash != null;
    }

    public int getSubsidyDecreaseBlockCount() {
        return this.subsidyDecreaseBlockCount;
    }

    public String[] getDnsSeeds() {
        return this.dnsSeeds;
    }

    public int[] getAddrSeeds() {
        return this.addrSeeds;
    }

    public HttpDiscovery.Details[] getHttpSeeds() {
        return this.httpSeeds;
    }

    public abstract Block getGenesisBlock();

    public int getPort() {
        return this.port;
    }

    public long getPacketMagic() {
        return this.packetMagic;
    }

    public int getAddressHeader() {
        return this.addressHeader;
    }

    public int getP2SHHeader() {
        return this.p2shHeader;
    }

    public int getDumpedPrivateKeyHeader() {
        return this.dumpedPrivateKeyHeader;
    }

    public String getSegwitAddressHrp() {
        return this.segwitAddressHrp;
    }

    public int getTargetTimespan() {
        return this.targetTimespan;
    }

    public boolean allowEmptyPeerChain() {
        return true;
    }

    public int getInterval() {
        return this.interval;
    }

    public BigInteger getMaxTarget() {
        return this.maxTarget;
    }

    public int getBip32HeaderP2PKHpub() {
        return this.bip32HeaderP2PKHpub;
    }

    public int getBip32HeaderP2PKHpriv() {
        return this.bip32HeaderP2PKHpriv;
    }

    public int getBip32HeaderP2WPKHpub() {
        return this.bip32HeaderP2WPKHpub;
    }

    public int getBip32HeaderP2WPKHpriv() {
        return this.bip32HeaderP2WPKHpriv;
    }

    public abstract Coin getMaxMoney();

    @Deprecated
    public abstract Coin getMinNonDustOutput();

    public abstract MonetaryFormat getMonetaryFormat();

    public abstract String getUriScheme();

    public abstract boolean hasMaxMoney();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageSerializer getDefaultSerializer() {
        if (null == this.defaultSerializer) {
            NetworkParameters networkParameters = this;
            synchronized (networkParameters) {
                if (null == this.defaultSerializer) {
                    this.defaultSerializer = this.getSerializer(false);
                }
            }
        }
        return this.defaultSerializer;
    }

    public abstract BitcoinSerializer getSerializer(boolean var1);

    public int getMajorityEnforceBlockUpgrade() {
        return this.majorityEnforceBlockUpgrade;
    }

    public int getMajorityRejectBlockOutdated() {
        return this.majorityRejectBlockOutdated;
    }

    public int getMajorityWindow() {
        return this.majorityWindow;
    }

    public EnumSet<Block.VerifyFlag> getBlockVerificationFlags(Block block, VersionTally tally, Integer height) {
        Integer count;
        EnumSet<Block.VerifyFlag> flags = EnumSet.noneOf(Block.VerifyFlag.class);
        if (block.isBIP34() && null != (count = tally.getCountAtOrAbove(2L)) && count >= this.getMajorityEnforceBlockUpgrade()) {
            flags.add(Block.VerifyFlag.HEIGHT_IN_COINBASE);
        }
        return flags;
    }

    public EnumSet<Script.VerifyFlag> getTransactionVerificationFlags(Block block, Transaction transaction, VersionTally tally, Integer height) {
        EnumSet<Script.VerifyFlag> verifyFlags = EnumSet.noneOf(Script.VerifyFlag.class);
        if (block.getTimeSeconds() >= 1333238400L) {
            verifyFlags.add(Script.VerifyFlag.P2SH);
        }
        if (block.getVersion() >= 4L && tally.getCountAtOrAbove(4L) > this.getMajorityEnforceBlockUpgrade()) {
            verifyFlags.add(Script.VerifyFlag.CHECKLOCKTIMEVERIFY);
        }
        return verifyFlags;
    }

    public abstract int getProtocolVersionNum(ProtocolVersion var1);

    public static enum ProtocolVersion {
        MINIMUM(70000),
        PONG(60001),
        BLOOM_FILTER(70000),
        BLOOM_FILTER_BIP111(70011),
        WITNESS_VERSION(70012),
        FEEFILTER(70013),
        CURRENT(70013);

        private final int bitcoinProtocol;

        private ProtocolVersion(int bitcoinProtocol) {
            this.bitcoinProtocol = bitcoinProtocol;
        }

        public int getBitcoinProtocolVersion() {
            return this.bitcoinProtocol;
        }
    }
}

