/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import java.util.Locale;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;

class StoredClientChannel {
    int majorVersion;
    Sha256Hash id;
    Transaction contract;
    Transaction refund;
    long expiryTime;
    Transaction close;
    ECKey myKey;
    ECKey serverKey;
    Coin valueToMe;
    Coin refundFees;
    boolean active = false;

    StoredClientChannel(int majorVersion, Sha256Hash id, Transaction contract, Transaction refund, ECKey myKey, ECKey serverKey, Coin valueToMe, Coin refundFees, long expiryTime, boolean active) {
        this.majorVersion = majorVersion;
        this.id = id;
        this.contract = contract;
        this.refund = refund;
        this.myKey = myKey;
        this.serverKey = serverKey;
        this.valueToMe = valueToMe;
        this.refundFees = refundFees;
        this.expiryTime = expiryTime;
        this.active = active;
    }

    long expiryTimeSeconds() {
        switch (this.majorVersion) {
            case 1: {
                return this.refund.getLockTime() + 300L;
            }
            case 2: {
                return this.expiryTime + 300L;
            }
        }
        throw new IllegalStateException("Invalid version");
    }

    public String toString() {
        String newline = String.format(Locale.US, "%n", new Object[0]);
        String closeStr = this.close == null ? "still open" : this.close.toString().replaceAll(newline, newline + "   ");
        return String.format(Locale.US, "Stored client channel for server ID %s (%s)%n    Version:     %d%n    Key:         %s%n    Server key:  %s%n    Value left:  %s%n    Refund fees: %s%n    Expiry     : %s%n    Contract:  %sRefund:    %sClose:     %s", this.id, this.active ? "active" : "inactive", this.majorVersion, this.myKey, this.serverKey, this.valueToMe, this.refundFees, this.expiryTime, this.contract.toString().replaceAll(newline, newline + "    "), this.refund.toString().replaceAll(newline, newline + "    "), closeStr);
    }
}

